"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PROFILE_VALUES_ENUM = exports.PROFILE_VALUES = exports.PROFILES_MAP = exports.DEFAULT_TLS_FIELDS = exports.DEFAULT_THROTTLING_VALUE = exports.DEFAULT_TCP_SIMPLE_FIELDS = exports.DEFAULT_TCP_ADVANCED_FIELDS = exports.DEFAULT_NAMESPACE_STRING = exports.DEFAULT_ICMP_SIMPLE_FIELDS = exports.DEFAULT_ICMP_ADVANCED_FIELDS = exports.DEFAULT_HTTP_SIMPLE_FIELDS = exports.DEFAULT_HTTP_ADVANCED_FIELDS = exports.DEFAULT_FIELDS = exports.DEFAULT_COMMON_FIELDS = exports.DEFAULT_BROWSER_SIMPLE_FIELDS = exports.DEFAULT_BROWSER_ADVANCED_FIELDS = exports.CUSTOM_LABEL = exports.ALLOWED_SCHEDULES_IN_MINUTES = void 0;
var _i18n = require("@kbn/i18n");
var _monitor_management = require("../runtime_types/monitor_management");
var _monitor_management2 = require("./monitor_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_NAMESPACE_STRING = 'default';
exports.DEFAULT_NAMESPACE_STRING = DEFAULT_NAMESPACE_STRING;
let PROFILE_VALUES_ENUM;
exports.PROFILE_VALUES_ENUM = PROFILE_VALUES_ENUM;
(function (PROFILE_VALUES_ENUM) {
  PROFILE_VALUES_ENUM["DEFAULT"] = "default";
  PROFILE_VALUES_ENUM["CABLE"] = "cable";
  PROFILE_VALUES_ENUM["DSL"] = "dsl";
  PROFILE_VALUES_ENUM["THREE_G"] = "3g";
  PROFILE_VALUES_ENUM["FOUR_G"] = "4g";
  PROFILE_VALUES_ENUM["LTE"] = "lte";
  PROFILE_VALUES_ENUM["FIBRE"] = "fibre";
  PROFILE_VALUES_ENUM["NO_THROTTLING"] = "no-throttling";
  PROFILE_VALUES_ENUM["CUSTOM"] = "custom";
})(PROFILE_VALUES_ENUM || (exports.PROFILE_VALUES_ENUM = PROFILE_VALUES_ENUM = {}));
const CUSTOM_LABEL = _i18n.i18n.translate('xpack.synthetics.connectionProfile.custom', {
  defaultMessage: 'Custom'
});
exports.CUSTOM_LABEL = CUSTOM_LABEL;
const DEFAULT_THROTTLING_VALUE = {
  download: '5',
  upload: '3',
  latency: '20'
};
exports.DEFAULT_THROTTLING_VALUE = DEFAULT_THROTTLING_VALUE;
const PROFILE_VALUES = [{
  value: DEFAULT_THROTTLING_VALUE,
  id: PROFILE_VALUES_ENUM.DEFAULT,
  label: _i18n.i18n.translate('xpack.synthetics.connectionProfile.default', {
    defaultMessage: 'Default'
  })
}, {
  value: {
    download: '5',
    upload: '1',
    latency: '28'
  },
  id: PROFILE_VALUES_ENUM.CABLE,
  label: _i18n.i18n.translate('xpack.synthetics.connectionProfile.cable', {
    defaultMessage: 'Cable'
  })
}, {
  value: {
    download: '1.5',
    upload: '0.384',
    latency: '50'
  },
  id: PROFILE_VALUES_ENUM.DSL,
  label: _i18n.i18n.translate('xpack.synthetics.connectionProfile.dsl', {
    defaultMessage: 'DSL'
  })
}, {
  value: {
    download: '1.6',
    upload: '0.768',
    latency: '300'
  },
  id: PROFILE_VALUES_ENUM.THREE_G,
  label: _i18n.i18n.translate('xpack.synthetics.connectionProfile.threeG', {
    defaultMessage: '3G'
  })
}, {
  value: {
    download: '9',
    upload: '0.75',
    latency: '170'
  },
  id: PROFILE_VALUES_ENUM.FOUR_G,
  label: _i18n.i18n.translate('xpack.synthetics.connectionProfile.fourG', {
    defaultMessage: '4G'
  })
}, {
  value: {
    download: '12',
    upload: '0.75',
    latency: '70'
  },
  id: PROFILE_VALUES_ENUM.LTE,
  label: _i18n.i18n.translate('xpack.synthetics.connectionProfile.lte', {
    defaultMessage: 'LTE'
  })
}, {
  value: {
    download: '20',
    upload: '5',
    latency: '4'
  },
  id: PROFILE_VALUES_ENUM.FIBRE,
  label: _i18n.i18n.translate('xpack.synthetics.connectionProfile.fibre', {
    defaultMessage: 'Fibre'
  })
}, {
  value: null,
  id: PROFILE_VALUES_ENUM.NO_THROTTLING,
  label: _i18n.i18n.translate('xpack.synthetics.connectionProfile.noThrottling', {
    defaultMessage: 'No throttling'
  })
}];
exports.PROFILE_VALUES = PROFILE_VALUES;
const PROFILES_MAP = PROFILE_VALUES.reduce((acc, profile) => {
  acc[profile.id] = profile;
  return acc;
}, {});
exports.PROFILES_MAP = PROFILES_MAP;
const ALLOWED_SCHEDULES_IN_MINUTES = ['1', '3', '5', '10', '15', '20', '30', '60', '120', '240'];
exports.ALLOWED_SCHEDULES_IN_MINUTES = ALLOWED_SCHEDULES_IN_MINUTES;
const DEFAULT_COMMON_FIELDS = {
  [_monitor_management2.ConfigKey.MONITOR_TYPE]: _monitor_management.DataStream.HTTP,
  [_monitor_management2.ConfigKey.FORM_MONITOR_TYPE]: _monitor_management.FormMonitorType.MULTISTEP,
  [_monitor_management2.ConfigKey.ENABLED]: true,
  [_monitor_management2.ConfigKey.ALERT_CONFIG]: {
    status: {
      enabled: true
    }
  },
  [_monitor_management2.ConfigKey.SCHEDULE]: {
    number: '3',
    unit: _monitor_management.ScheduleUnit.MINUTES
  },
  [_monitor_management2.ConfigKey.APM_SERVICE_NAME]: '',
  [_monitor_management2.ConfigKey.CONFIG_ID]: '',
  [_monitor_management2.ConfigKey.TAGS]: [],
  [_monitor_management2.ConfigKey.TIMEOUT]: '16',
  [_monitor_management2.ConfigKey.NAME]: '',
  [_monitor_management2.ConfigKey.LOCATIONS]: [],
  [_monitor_management2.ConfigKey.NAMESPACE]: DEFAULT_NAMESPACE_STRING,
  [_monitor_management2.ConfigKey.MONITOR_SOURCE_TYPE]: _monitor_management.SourceType.UI,
  [_monitor_management2.ConfigKey.JOURNEY_ID]: '',
  [_monitor_management2.ConfigKey.CONFIG_HASH]: '',
  [_monitor_management2.ConfigKey.MONITOR_QUERY_ID]: '',
  [_monitor_management2.ConfigKey.PARAMS]: ''
};
exports.DEFAULT_COMMON_FIELDS = DEFAULT_COMMON_FIELDS;
const DEFAULT_BROWSER_ADVANCED_FIELDS = {
  [_monitor_management2.ConfigKey.SCREENSHOTS]: _monitor_management.ScreenshotOption.ON,
  [_monitor_management2.ConfigKey.SYNTHETICS_ARGS]: [],
  [_monitor_management2.ConfigKey.JOURNEY_FILTERS_MATCH]: '',
  [_monitor_management2.ConfigKey.JOURNEY_FILTERS_TAGS]: [],
  [_monitor_management2.ConfigKey.IGNORE_HTTPS_ERRORS]: false,
  [_monitor_management2.ConfigKey.THROTTLING_CONFIG]: PROFILES_MAP[PROFILE_VALUES_ENUM.DEFAULT]
};
exports.DEFAULT_BROWSER_ADVANCED_FIELDS = DEFAULT_BROWSER_ADVANCED_FIELDS;
const DEFAULT_BROWSER_SIMPLE_FIELDS = {
  ...DEFAULT_COMMON_FIELDS,
  [_monitor_management2.ConfigKey.PROJECT_ID]: '',
  [_monitor_management2.ConfigKey.PLAYWRIGHT_OPTIONS]: '',
  [_monitor_management2.ConfigKey.METADATA]: {
    script_source: {
      is_generated_script: false,
      file_name: ''
    }
  },
  [_monitor_management2.ConfigKey.MONITOR_TYPE]: _monitor_management.DataStream.BROWSER,
  [_monitor_management2.ConfigKey.PORT]: null,
  [_monitor_management2.ConfigKey.SCHEDULE]: {
    unit: _monitor_management.ScheduleUnit.MINUTES,
    number: '10'
  },
  [_monitor_management2.ConfigKey.SOURCE_INLINE]: '',
  [_monitor_management2.ConfigKey.SOURCE_PROJECT_CONTENT]: '',
  [_monitor_management2.ConfigKey.TEXT_ASSERTION]: '',
  [_monitor_management2.ConfigKey.URLS]: '',
  [_monitor_management2.ConfigKey.FORM_MONITOR_TYPE]: _monitor_management.FormMonitorType.MULTISTEP,
  [_monitor_management2.ConfigKey.TIMEOUT]: null
};
exports.DEFAULT_BROWSER_SIMPLE_FIELDS = DEFAULT_BROWSER_SIMPLE_FIELDS;
const DEFAULT_HTTP_SIMPLE_FIELDS = {
  ...DEFAULT_COMMON_FIELDS,
  [_monitor_management2.ConfigKey.METADATA]: {
    is_tls_enabled: false
  },
  [_monitor_management2.ConfigKey.URLS]: '',
  [_monitor_management2.ConfigKey.MAX_REDIRECTS]: '0',
  [_monitor_management2.ConfigKey.MONITOR_TYPE]: _monitor_management.DataStream.HTTP,
  [_monitor_management2.ConfigKey.FORM_MONITOR_TYPE]: _monitor_management.FormMonitorType.HTTP,
  [_monitor_management2.ConfigKey.PORT]: null
};
exports.DEFAULT_HTTP_SIMPLE_FIELDS = DEFAULT_HTTP_SIMPLE_FIELDS;
const DEFAULT_HTTP_ADVANCED_FIELDS = {
  [_monitor_management2.ConfigKey.PASSWORD]: '',
  [_monitor_management2.ConfigKey.PROXY_URL]: '',
  [_monitor_management2.ConfigKey.PROXY_HEADERS]: {},
  [_monitor_management2.ConfigKey.RESPONSE_BODY_CHECK_NEGATIVE]: [],
  [_monitor_management2.ConfigKey.RESPONSE_BODY_CHECK_POSITIVE]: [],
  [_monitor_management2.ConfigKey.RESPONSE_JSON_CHECK]: [],
  [_monitor_management2.ConfigKey.RESPONSE_BODY_INDEX]: _monitor_management.ResponseBodyIndexPolicy.ON_ERROR,
  [_monitor_management2.ConfigKey.RESPONSE_HEADERS_CHECK]: {},
  [_monitor_management2.ConfigKey.RESPONSE_HEADERS_INDEX]: true,
  [_monitor_management2.ConfigKey.RESPONSE_STATUS_CHECK]: [],
  [_monitor_management2.ConfigKey.REQUEST_BODY_CHECK]: {
    value: '',
    type: _monitor_management.CodeEditorMode.PLAINTEXT
  },
  [_monitor_management2.ConfigKey.REQUEST_HEADERS_CHECK]: {},
  [_monitor_management2.ConfigKey.REQUEST_METHOD_CHECK]: _monitor_management.HTTPMethod.GET,
  [_monitor_management2.ConfigKey.USERNAME]: '',
  [_monitor_management2.ConfigKey.MODE]: _monitor_management.Mode.ANY,
  [_monitor_management2.ConfigKey.RESPONSE_BODY_MAX_BYTES]: '1024',
  [_monitor_management2.ConfigKey.IPV4]: true,
  [_monitor_management2.ConfigKey.IPV6]: true
};
exports.DEFAULT_HTTP_ADVANCED_FIELDS = DEFAULT_HTTP_ADVANCED_FIELDS;
const DEFAULT_ICMP_SIMPLE_FIELDS = {
  ...DEFAULT_COMMON_FIELDS,
  [_monitor_management2.ConfigKey.HOSTS]: '',
  [_monitor_management2.ConfigKey.MONITOR_TYPE]: _monitor_management.DataStream.ICMP,
  [_monitor_management2.ConfigKey.WAIT]: '1',
  [_monitor_management2.ConfigKey.FORM_MONITOR_TYPE]: _monitor_management.FormMonitorType.ICMP
};
exports.DEFAULT_ICMP_SIMPLE_FIELDS = DEFAULT_ICMP_SIMPLE_FIELDS;
const DEFAULT_TCP_SIMPLE_FIELDS = {
  ...DEFAULT_COMMON_FIELDS,
  [_monitor_management2.ConfigKey.METADATA]: {
    is_tls_enabled: false
  },
  [_monitor_management2.ConfigKey.HOSTS]: '',
  [_monitor_management2.ConfigKey.URLS]: '',
  [_monitor_management2.ConfigKey.MONITOR_TYPE]: _monitor_management.DataStream.TCP,
  [_monitor_management2.ConfigKey.FORM_MONITOR_TYPE]: _monitor_management.FormMonitorType.TCP,
  [_monitor_management2.ConfigKey.PORT]: null
};
exports.DEFAULT_TCP_SIMPLE_FIELDS = DEFAULT_TCP_SIMPLE_FIELDS;
const DEFAULT_TCP_ADVANCED_FIELDS = {
  [_monitor_management2.ConfigKey.PROXY_URL]: '',
  [_monitor_management2.ConfigKey.PROXY_USE_LOCAL_RESOLVER]: false,
  [_monitor_management2.ConfigKey.RESPONSE_RECEIVE_CHECK]: '',
  [_monitor_management2.ConfigKey.REQUEST_SEND_CHECK]: '',
  [_monitor_management2.ConfigKey.MODE]: _monitor_management.Mode.ANY,
  [_monitor_management2.ConfigKey.IPV4]: true,
  [_monitor_management2.ConfigKey.IPV6]: true
};
exports.DEFAULT_TCP_ADVANCED_FIELDS = DEFAULT_TCP_ADVANCED_FIELDS;
const DEFAULT_ICMP_ADVANCED_FIELDS = {
  [_monitor_management2.ConfigKey.MODE]: _monitor_management.Mode.ANY,
  [_monitor_management2.ConfigKey.IPV4]: true,
  [_monitor_management2.ConfigKey.IPV6]: true
};
exports.DEFAULT_ICMP_ADVANCED_FIELDS = DEFAULT_ICMP_ADVANCED_FIELDS;
const DEFAULT_TLS_FIELDS = {
  [_monitor_management2.ConfigKey.TLS_CERTIFICATE_AUTHORITIES]: '',
  [_monitor_management2.ConfigKey.TLS_CERTIFICATE]: '',
  [_monitor_management2.ConfigKey.TLS_KEY]: '',
  [_monitor_management2.ConfigKey.TLS_KEY_PASSPHRASE]: '',
  [_monitor_management2.ConfigKey.TLS_VERIFICATION_MODE]: _monitor_management.VerificationMode.FULL,
  [_monitor_management2.ConfigKey.TLS_VERSION]: [_monitor_management.TLSVersion.ONE_ONE, _monitor_management.TLSVersion.ONE_TWO, _monitor_management.TLSVersion.ONE_THREE]
};
exports.DEFAULT_TLS_FIELDS = DEFAULT_TLS_FIELDS;
const DEFAULT_FIELDS = {
  [_monitor_management.DataStream.HTTP]: {
    ...DEFAULT_HTTP_SIMPLE_FIELDS,
    ...DEFAULT_HTTP_ADVANCED_FIELDS,
    ...DEFAULT_TLS_FIELDS
  },
  [_monitor_management.DataStream.TCP]: {
    ...DEFAULT_TCP_SIMPLE_FIELDS,
    ...DEFAULT_TCP_ADVANCED_FIELDS,
    ...DEFAULT_TLS_FIELDS
  },
  [_monitor_management.DataStream.ICMP]: {
    ...DEFAULT_ICMP_SIMPLE_FIELDS,
    ...DEFAULT_ICMP_ADVANCED_FIELDS
  },
  [_monitor_management.DataStream.BROWSER]: {
    ...DEFAULT_BROWSER_SIMPLE_FIELDS,
    ...DEFAULT_BROWSER_ADVANCED_FIELDS,
    ...DEFAULT_TLS_FIELDS
  }
};
exports.DEFAULT_FIELDS = DEFAULT_FIELDS;