"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.api = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChannelsHandler = async ({
  externalService
}) => await externalService.getChannels();
const postMessageHandler = async ({
  externalService,
  params: {
    channels,
    text
  }
}) => await externalService.postMessage({
  channels,
  text
});
const api = {
  getChannels: getChannelsHandler,
  postMessage: postMessageHandler
};
exports.api = api;