"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _types = require("../types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const isBasicAuth = auth => {
  if (auth == null) {
    return true;
  }
  return auth.auth === _types.XmattersAuthenticationType.Basic ? true : false;
};
const authenticationButtons = [{
  id: _types.XmattersAuthenticationType.Basic,
  label: i18n.BASIC_AUTH_BUTTON_LABEL
}, {
  id: _types.XmattersAuthenticationType.URL,
  label: i18n.URL_AUTH_BUTTON_LABEL
}];
const XmattersUrlField = ({
  path,
  readOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    component: _components.TextField,
    config: {
      label: i18n.URL_LABEL,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.xmatters.initiationUrlHelpText",
        defaultMessage: "Include the full xMatters url."
      }),
      validations: [{
        validator: urlField(i18n.URL_INVALID)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': path,
        readOnly
      }
    }
  });
};
const XmattersActionConnectorFields = ({
  readOnly
}) => {
  var _getFieldDefaultValue;
  const {
    setFieldValue,
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    __internal__
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.usesBasic', '__internal__.auth']
  });
  const usesBasicDefaultValue = (_getFieldDefaultValue = getFieldDefaultValue('config.usesBasic')) !== null && _getFieldDefaultValue !== void 0 ? _getFieldDefaultValue : true;
  const selectedAuthDefaultValue = usesBasicDefaultValue ? _types.XmattersAuthenticationType.Basic : _types.XmattersAuthenticationType.URL;
  const selectedAuth = config != null && !config.usesBasic ? _types.XmattersAuthenticationType.URL : _types.XmattersAuthenticationType.Basic;
  (0, _react.useEffect)(() => {
    setFieldValue('config.usesBasic', isBasicAuth(__internal__));
  }, [__internal__, setFieldValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.xmatters.authenticationLabel",
    defaultMessage: "Authentication"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_public.ButtonGroupField, {
    defaultValue: selectedAuthDefaultValue,
    path: '__internal__.auth',
    label: i18n.BASIC_AUTH_LABEL,
    legend: i18n.BASIC_AUTH_BUTTON_GROUP_LEGEND,
    options: authenticationButtons
  }), /*#__PURE__*/_react.default.createElement(_public.HiddenField, {
    path: 'config.usesBasic',
    config: {
      defaultValue: true
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), selectedAuth === _types.XmattersAuthenticationType.URL ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(XmattersUrlField, {
    path: "secrets.secretsUrl",
    readOnly: readOnly
  }))) : null, selectedAuth === _types.XmattersAuthenticationType.Basic ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(XmattersUrlField, {
    path: "config.configUrl",
    readOnly: readOnly
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "userCredsLabel",
    id: "xpack.stackConnectors.components.xmatters.userCredsLabel",
    defaultMessage: "User credentials"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.user",
    component: _components.TextField,
    config: {
      label: i18n.USERNAME_LABEL,
      validations: [{
        validator: emptyField(i18n.USERNAME_INVALID)
      }]
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'xmattersUserInput',
        readOnly
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.PasswordField, {
    path: "secrets.password",
    label: i18n.PASSWORD_LABEL,
    readOnly: readOnly,
    "data-test-subj": "xmattersPasswordInput"
  })))) : null);
};

// eslint-disable-next-line import/no-default-export
exports.default = XmattersActionConnectorFields;
module.exports = exports.default;