"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERNAME_LABEL = exports.USERNAME_INVALID = exports.URL_REQUIRED = exports.URL_LABEL = exports.URL_INVALID = exports.URL_AUTH_BUTTON_LABEL = exports.PASSWORD_LABEL = exports.BASIC_AUTH_LABEL = exports.BASIC_AUTH_BUTTON_LABEL = exports.BASIC_AUTH_BUTTON_GROUP_LEGEND = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASIC_AUTH_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.connectorSettingsLabel', {
  defaultMessage: 'Select the authentication method used when setting up the xMatters trigger.'
});
exports.BASIC_AUTH_LABEL = BASIC_AUTH_LABEL;
const BASIC_AUTH_BUTTON_GROUP_LEGEND = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.basicAuthButtonGroupLegend', {
  defaultMessage: 'Basic Authentication'
});
exports.BASIC_AUTH_BUTTON_GROUP_LEGEND = BASIC_AUTH_BUTTON_GROUP_LEGEND;
const URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.urlLabel', {
  defaultMessage: 'Initiation URL'
});
exports.URL_LABEL = URL_LABEL;
const USERNAME_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.userTextFieldLabel', {
  defaultMessage: 'Username'
});
exports.USERNAME_LABEL = USERNAME_LABEL;
const PASSWORD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.passwordTextFieldLabel', {
  defaultMessage: 'Password'
});
exports.PASSWORD_LABEL = PASSWORD_LABEL;
const BASIC_AUTH_BUTTON_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.basicAuthLabel', {
  defaultMessage: 'Basic Authentication'
});
exports.BASIC_AUTH_BUTTON_LABEL = BASIC_AUTH_BUTTON_LABEL;
const URL_AUTH_BUTTON_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.urlAuthLabel', {
  defaultMessage: 'URL Authentication'
});
exports.URL_AUTH_BUTTON_LABEL = URL_AUTH_BUTTON_LABEL;
const URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.error.requiredUrlText', {
  defaultMessage: 'URL is required.'
});
exports.URL_REQUIRED = URL_REQUIRED;
const URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.error.invalidUrlTextField', {
  defaultMessage: 'URL is invalid.'
});
exports.URL_INVALID = URL_INVALID;
const USERNAME_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.error.invalidUsernameTextField', {
  defaultMessage: 'Username is invalid.'
});
exports.USERNAME_INVALID = USERNAME_INVALID;