"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HTTP_VERBS = ['post', 'put'];
const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const WebhookActionConnectorFields = ({
  readOnly
}) => {
  const {
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    __internal__
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.hasAuth', '__internal__.hasHeaders']
  });
  const hasHeadersDefaultValue = !!getFieldDefaultValue('config.headers');
  const hasAuth = config == null ? true : config.hasAuth;
  const hasHeaders = __internal__ != null ? __internal__.hasHeaders : false;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.method",
    component: _components.SelectField,
    config: {
      label: i18n.METHOD_LABEL,
      defaultValue: 'post',
      validations: [{
        validator: emptyField(i18n.METHOD_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'webhookMethodSelect',
        options: HTTP_VERBS.map(verb => ({
          text: verb.toUpperCase(),
          value: verb
        })),
        fullWidth: true,
        readOnly
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.url",
    config: {
      label: i18n.URL_LABEL,
      validations: [{
        validator: urlField(i18n.URL_INVALID)
      }]
    },
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'webhookUrlText',
        fullWidth: true
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.webhook.authenticationLabel",
    defaultMessage: "Authentication"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.hasAuth",
    component: _components.ToggleField,
    config: {
      defaultValue: true
    },
    componentProps: {
      euiFieldProps: {
        label: i18n.HAS_AUTH_LABEL,
        disabled: readOnly
      }
    }
  }))), hasAuth ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.user",
    config: {
      label: i18n.USERNAME_LABEL,
      validations: [{
        validator: emptyField(i18n.USERNAME_REQUIRED)
      }]
    },
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'webhookUserInput',
        fullWidth: true
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.PasswordField, {
    path: "secrets.password",
    label: i18n.PASSWORD_LABEL,
    readOnly: readOnly,
    "data-test-subj": "webhookPasswordInput"
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.hasHeaders",
    component: _components.ToggleField,
    config: {
      defaultValue: hasHeadersDefaultValue,
      label: i18n.ADD_HEADERS_LABEL
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'webhookViewHeadersSwitch'
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), hasHeaders ? /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseArray, {
    path: "config.headers",
    initialNumberOfItems: 1
  }, ({
    items,
    addItem,
    removeItem
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: item.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
      path: `${item.path}.key`,
      config: {
        label: i18n.HEADER_KEY_LABEL
      },
      component: _components.TextField
      // This is needed because when you delete
      // a row and add a new one, the stale values will appear
      ,
      readDefaultValueOnForm: !item.isNew,
      componentProps: {
        euiFieldProps: {
          readOnly
        }
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
      path: `${item.path}.value`,
      config: {
        label: i18n.HEADER_VALUE_LABEL
      },
      component: _components.TextField,
      readDefaultValueOnForm: !item.isNew,
      componentProps: {
        euiFieldProps: {
          readOnly
        }
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "danger",
      onClick: () => removeItem(item.id),
      iconType: "minusInCircle",
      "aria-label": i18n.REMOVE_ITEM_LABEL,
      style: {
        marginTop: '28px'
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "plusInCircle",
      onClick: addItem
    }, i18n.ADD_HEADER_BTN), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }) : null);
};

// eslint-disable-next-line import/no-default-export
exports.default = WebhookActionConnectorFields;
module.exports = exports.default;