"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TorqParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  errors
}) => {
  var _errors$body;
  const {
    body
  } = actionParams;
  return /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: i18n.BODY_FIELD_LABEL,
    "aria-label": i18n.BODY_FIELD_ARIA_LABEL,
    errors: errors.body,
    onDocumentsChange: json => {
      editAction('body', json, index);
    },
    onBlur: () => {
      if (!body) {
        editAction('body', '', index);
      }
    },
    euiCodeEditorProps: {
      options: {
        renderValidationDecorations: body && errors !== null && errors !== void 0 && (_errors$body = errors.body) !== null && _errors$body !== void 0 && _errors$body.length ? 'on' : 'off',
        lineNumbers: 'on',
        fontSize: 14,
        minimap: {
          enabled: false
        },
        scrollBeyondLastLine: false,
        folding: true,
        wordWrap: 'on',
        wrappingIndent: 'indent',
        automaticLayout: true
      }
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = TorqParamsFields;
module.exports = exports.default;