"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SW_SEVERITY_FIELD_LABEL = exports.SW_RULE_NAME_FIELD_LABEL = exports.SW_REQUIRED_SEVERITY = exports.SW_REQUIRED_RULE_NAME = exports.SW_REQUIRED_DESCRIPTION = exports.SW_REQUIRED_COMMENTS = exports.SW_REQUIRED_CASE_NAME = exports.SW_REQUIRED_CASE_ID = exports.SW_REQUIRED_APP_ID_TEXT = exports.SW_REQUIRED_ALERT_ID = exports.SW_NEXT = exports.SW_MAPPING_TITLE_TEXT_FIELD_LABEL = exports.SW_GET_APPLICATION_API_NO_FIELDS_ERROR = exports.SW_GET_APPLICATION_API_ERROR = exports.SW_FIELDS_BUTTON_HELP_TEXT = exports.SW_DESCRIPTION_FIELD_LABEL = exports.SW_CONNECTOR_TYPE_LABEL = exports.SW_CONFIGURE_CONNECTION_LABEL = exports.SW_COMMENTS_FIELD_LABEL = exports.SW_CASE_NAME_FIELD_LABEL = exports.SW_CASE_ID_FIELD_LABEL = exports.SW_BACK = exports.SW_APP_ID_TEXT_FIELD_LABEL = exports.SW_API_URL_TEXT_FIELD_LABEL = exports.SW_API_URL_INVALID = exports.SW_API_TOKEN_TEXT_FIELD_LABEL = exports.SW_ALERT_ID_FIELD_LABEL = exports.EMPTY_MAPPING_WARNING_TITLE = exports.EMPTY_MAPPING_WARNING_DESC = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SW_REQUIRED_RULE_NAME = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredRuleName', {
  defaultMessage: 'Rule name is required.'
});
exports.SW_REQUIRED_RULE_NAME = SW_REQUIRED_RULE_NAME;
const SW_REQUIRED_APP_ID_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredAppIdText', {
  defaultMessage: 'An App ID is required.'
});
exports.SW_REQUIRED_APP_ID_TEXT = SW_REQUIRED_APP_ID_TEXT;
const SW_GET_APPLICATION_API_ERROR = id => _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.unableToGetApplicationMessage', {
  defaultMessage: 'Unable to get application with id {id}',
  values: {
    id
  }
});
exports.SW_GET_APPLICATION_API_ERROR = SW_GET_APPLICATION_API_ERROR;
const SW_GET_APPLICATION_API_NO_FIELDS_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.unableToGetApplicationFieldsMessage', {
  defaultMessage: 'Unable to get application fields'
});
exports.SW_GET_APPLICATION_API_NO_FIELDS_ERROR = SW_GET_APPLICATION_API_NO_FIELDS_ERROR;
const SW_API_URL_TEXT_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.apiUrlTextFieldLabel', {
  defaultMessage: 'API Url'
});
exports.SW_API_URL_TEXT_FIELD_LABEL = SW_API_URL_TEXT_FIELD_LABEL;
const SW_API_URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.invalidApiUrlTextField', {
  defaultMessage: 'URL is invalid.'
});
exports.SW_API_URL_INVALID = SW_API_URL_INVALID;
const SW_APP_ID_TEXT_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.appIdTextFieldLabel', {
  defaultMessage: 'Application ID'
});
exports.SW_APP_ID_TEXT_FIELD_LABEL = SW_APP_ID_TEXT_FIELD_LABEL;
const SW_API_TOKEN_TEXT_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.apiTokenTextFieldLabel', {
  defaultMessage: 'API Token'
});
exports.SW_API_TOKEN_TEXT_FIELD_LABEL = SW_API_TOKEN_TEXT_FIELD_LABEL;
const SW_MAPPING_TITLE_TEXT_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.mappingTitleTextFieldLabel', {
  defaultMessage: 'Configure Field Mappings'
});
exports.SW_MAPPING_TITLE_TEXT_FIELD_LABEL = SW_MAPPING_TITLE_TEXT_FIELD_LABEL;
const SW_SEVERITY_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.severityFieldLabel', {
  defaultMessage: 'Severity'
});
exports.SW_SEVERITY_FIELD_LABEL = SW_SEVERITY_FIELD_LABEL;
const SW_RULE_NAME_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.ruleNameFieldLabel', {
  defaultMessage: 'Rule name'
});
exports.SW_RULE_NAME_FIELD_LABEL = SW_RULE_NAME_FIELD_LABEL;
const SW_ALERT_ID_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.alertIdFieldLabel', {
  defaultMessage: 'Alert ID'
});
exports.SW_ALERT_ID_FIELD_LABEL = SW_ALERT_ID_FIELD_LABEL;
const SW_CASE_ID_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.caseIdFieldLabel', {
  defaultMessage: 'Case ID'
});
exports.SW_CASE_ID_FIELD_LABEL = SW_CASE_ID_FIELD_LABEL;
const SW_CASE_NAME_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.caseNameFieldLabel', {
  defaultMessage: 'Case name'
});
exports.SW_CASE_NAME_FIELD_LABEL = SW_CASE_NAME_FIELD_LABEL;
const SW_COMMENTS_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.commentsFieldLabel', {
  defaultMessage: 'Comments'
});
exports.SW_COMMENTS_FIELD_LABEL = SW_COMMENTS_FIELD_LABEL;
const SW_DESCRIPTION_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.descriptionFieldLabel', {
  defaultMessage: 'Description'
});
exports.SW_DESCRIPTION_FIELD_LABEL = SW_DESCRIPTION_FIELD_LABEL;
const SW_CONFIGURE_CONNECTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.configureConnectionLabel', {
  defaultMessage: 'Configure API Connection'
});
exports.SW_CONFIGURE_CONNECTION_LABEL = SW_CONFIGURE_CONNECTION_LABEL;
const SW_CONNECTOR_TYPE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.connectorType', {
  defaultMessage: 'Connector Type'
});
exports.SW_CONNECTOR_TYPE_LABEL = SW_CONNECTOR_TYPE_LABEL;
const EMPTY_MAPPING_WARNING_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.emptyMappingWarningTitle', {
  defaultMessage: 'This connector has missing field mappings'
});
exports.EMPTY_MAPPING_WARNING_TITLE = EMPTY_MAPPING_WARNING_TITLE;
const EMPTY_MAPPING_WARNING_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.emptyMappingWarningDesc', {
  defaultMessage: 'This connector cannot be selected because it is missing the required alert field mappings. You can edit this connector to add required field mappings or select a connector of type Alerts.'
});
exports.EMPTY_MAPPING_WARNING_DESC = EMPTY_MAPPING_WARNING_DESC;
const SW_REQUIRED_SEVERITY = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredSeverity', {
  defaultMessage: 'Severity is required.'
});
exports.SW_REQUIRED_SEVERITY = SW_REQUIRED_SEVERITY;
const SW_REQUIRED_CASE_NAME = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredCaseName', {
  defaultMessage: 'Case name is required.'
});
exports.SW_REQUIRED_CASE_NAME = SW_REQUIRED_CASE_NAME;
const SW_REQUIRED_CASE_ID = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredCaseID', {
  defaultMessage: 'Case ID is required.'
});
exports.SW_REQUIRED_CASE_ID = SW_REQUIRED_CASE_ID;
const SW_REQUIRED_COMMENTS = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredComments', {
  defaultMessage: 'Comments are required.'
});
exports.SW_REQUIRED_COMMENTS = SW_REQUIRED_COMMENTS;
const SW_REQUIRED_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredDescription', {
  defaultMessage: 'Description is required.'
});
exports.SW_REQUIRED_DESCRIPTION = SW_REQUIRED_DESCRIPTION;
const SW_REQUIRED_ALERT_ID = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.error.requiredAlertID', {
  defaultMessage: 'Alert ID is required.'
});
exports.SW_REQUIRED_ALERT_ID = SW_REQUIRED_ALERT_ID;
const SW_BACK = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.prevStep', {
  defaultMessage: 'Back'
});
exports.SW_BACK = SW_BACK;
const SW_NEXT = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.nextStep', {
  defaultMessage: 'Next'
});
exports.SW_NEXT = SW_NEXT;
const SW_FIELDS_BUTTON_HELP_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.nextStepHelpText', {
  defaultMessage: 'If field mappings are not configured, Swimlane connector type will be set to all.'
});
exports.SW_FIELDS_BUTTON_HELP_TEXT = SW_FIELDS_BUTTON_HELP_TEXT;