"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _steps = require("./steps");
var _use_get_application = require("./use_get_application");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SwimlaneActionConnectorFields = ({
  readOnly
}) => {
  var _config$apiUrl, _config$appId, _secrets$apiToken;
  const {
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const [hasConfigurationErrors, setHasConfigurationError] = (0, _react.useState)(false);
  const {
    isValid,
    validateFields
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    secrets
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.apiUrl', 'config.appId', 'secrets.apiToken']
  });
  const {
    getApplication,
    isLoading: isLoadingApplication
  } = (0, _use_get_application.useGetApplication)({
    toastNotifications: toasts
  });
  const apiUrl = (_config$apiUrl = config === null || config === void 0 ? void 0 : config.apiUrl) !== null && _config$apiUrl !== void 0 ? _config$apiUrl : '';
  const appId = (_config$appId = config === null || config === void 0 ? void 0 : config.appId) !== null && _config$appId !== void 0 ? _config$appId : '';
  const apiToken = (_secrets$apiToken = secrets === null || secrets === void 0 ? void 0 : secrets.apiToken) !== null && _secrets$apiToken !== void 0 ? _secrets$apiToken : '';
  const [currentStep, setCurrentStep] = (0, _react.useState)(1);
  const [fields, setFields] = (0, _react.useState)([]);
  const updateCurrentStep = (0, _react.useCallback)(step => {
    setCurrentStep(step);
  }, []);
  const onNextStep = (0, _react.useCallback)(async () => {
    setHasConfigurationError(false);
    const {
      areFieldsValid
    } = await validateFields(['config.apiUrl', 'config.appId', 'secrets.apiToken']);
    if (!areFieldsValid) {
      setHasConfigurationError(true);
      return;
    }

    // fetch swimlane application configuration
    const application = await getApplication({
      apiUrl,
      appId,
      apiToken
    });
    if (application !== null && application !== void 0 && application.fields) {
      const allFields = application.fields;
      setFields(allFields);
      setCurrentStep(2);
    }
  }, [apiToken, apiUrl, appId, getApplication, validateFields]);
  const resetConnection = (0, _react.useCallback)(() => {
    setCurrentStep(1);
  }, []);
  const steps = (0, _react.useMemo)(() => [{
    title: i18n.SW_CONFIGURE_CONNECTION_LABEL,
    isSelected: currentStep === 1,
    status: currentStep === 1 ? 'selected' : currentStep === 2 ? 'complete' : 'incomplete',
    onClick: () => updateCurrentStep(1)
  }, {
    title: i18n.SW_MAPPING_TITLE_TEXT_FIELD_LABEL,
    disabled: hasConfigurationErrors || isLoadingApplication,
    onClick: onNextStep,
    status: !isValid ? 'danger' : currentStep === 2 ? 'selected' : 'incomplete'
  }], [currentStep, hasConfigurationErrors, isLoadingApplication, isValid, onNextStep, updateCurrentStep]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: steps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: currentStep === 1 ? 'block' : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.SwimlaneConnection, {
    readOnly: readOnly
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: i18n.SW_FIELDS_BUTTON_HELP_TEXT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton
  // disabled={hasConfigurationErrors || isLoadingApplication}
  , {
    isLoading: isLoadingApplication,
    onClick: onNextStep,
    "data-test-subj": "swimlaneConfigureMapping",
    iconType: "arrowRight",
    iconSide: "right"
  }, i18n.SW_NEXT))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: currentStep === 2 ? 'block' : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.SwimlaneFields, {
    fields: fields,
    readOnly: readOnly
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: resetConnection,
    iconType: "arrowLeft"
  }, i18n.SW_BACK))));
};

// eslint-disable-next-line import/no-default-export
exports.default = SwimlaneActionConnectorFields;
module.exports = exports.default;