"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwimlaneFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("../types");
var _helpers = require("../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SINGLE_SELECTION = {
  asPlainText: true
};
const EMPTY_COMBO_BOX_ARRAY = [];
const formatOption = field => ({
  label: `${field.name} (${field.key})`,
  value: field.id
});
const createSelectedOption = field => field != null ? [formatOption(field)] : EMPTY_COMBO_BOX_ARRAY;
const connectorTypeButtons = [{
  id: _types.SwimlaneConnectorType.All,
  label: 'All'
}, {
  id: _types.SwimlaneConnectorType.Alerts,
  label: 'Alerts'
}, {
  id: _types.SwimlaneConnectorType.Cases,
  label: 'Cases'
}];
const mappingConfig = {
  defaultValue: null,
  validations: [{
    validator: ({
      value,
      customData
    }) => {
      const data = customData.value;
      if ((0, _helpers.isRequiredField)(data.connectorType, value === null || value === void 0 ? void 0 : value.id)) {
        return {
          message: data.validationLabel
        };
      }
    }
  }]
};
const MappingField = /*#__PURE__*/_react.default.memo(({
  path,
  options,
  label,
  validationLabel,
  dataTestSubj,
  fieldIdMap,
  connectorType,
  readOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    component: _components.ComboBoxField,
    config: mappingConfig,
    validationData: {
      connectorType,
      validationLabel
    }
  }, field => {
    var _field$value$id, _field$value;
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onComboChange = opt => {
      var _option$value;
      const option = opt[0];
      const item = fieldIdMap.get((_option$value = option === null || option === void 0 ? void 0 : option.value) !== null && _option$value !== void 0 ? _option$value : '');
      if (!item) {
        field.setValue(null);
        return;
      }
      field.setValue({
        id: item.id,
        name: item.name,
        key: item.key,
        fieldType: item.fieldType
      });
    };
    const onSearchComboChange = value => {
      if (value !== undefined) {
        field.clearErrors(_hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM);
      }
    };
    const selectedOptions = createSelectedOption(fieldIdMap.get((_field$value$id = (_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.id) !== null && _field$value$id !== void 0 ? _field$value$id : ''));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      error: errorMessage,
      isInvalid: isInvalid,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      singleSelection: SINGLE_SELECTION,
      selectedOptions: selectedOptions,
      onChange: onComboChange,
      onSearchChange: onSearchComboChange,
      fullWidth: true,
      noSuggestions: false,
      "data-test-subj": dataTestSubj,
      options: options,
      isDisabled: readOnly
    }));
  });
});
const SwimlaneFieldsComponent = ({
  fields,
  readOnly
}) => {
  var _config$connectorType;
  const [{
    config
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.connectorType']
  });
  const connectorType = (_config$connectorType = config === null || config === void 0 ? void 0 : config.connectorType) !== null && _config$connectorType !== void 0 ? _config$connectorType : _types.SwimlaneConnectorType.All;
  const [fieldTypeMap, fieldIdMap] = (0, _react.useMemo)(() => fields.reduce(([typeMap, idMap], field) => {
    if (field != null) {
      var _typeMap$get;
      typeMap.set(field.fieldType, [...((_typeMap$get = typeMap.get(field.fieldType)) !== null && _typeMap$get !== void 0 ? _typeMap$get : []), formatOption(field)]);
      idMap.set(field.id, field);
    }
    return [typeMap, idMap];
  }, [new Map(), new Map()]), [fields]);
  const textOptions = (0, _react.useMemo)(() => {
    var _fieldTypeMap$get;
    return (_fieldTypeMap$get = fieldTypeMap.get('text')) !== null && _fieldTypeMap$get !== void 0 ? _fieldTypeMap$get : [];
  }, [fieldTypeMap]);
  const commentsOptions = (0, _react.useMemo)(() => {
    var _fieldTypeMap$get2;
    return (_fieldTypeMap$get2 = fieldTypeMap.get('comments')) !== null && _fieldTypeMap$get2 !== void 0 ? _fieldTypeMap$get2 : [];
  }, [fieldTypeMap]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.ButtonGroupField, {
    defaultValue: _types.SwimlaneConnectorType.All,
    path: 'config.connectorType',
    label: i18n.SW_CONNECTOR_TYPE_LABEL,
    legend: i18n.SW_CONNECTOR_TYPE_LABEL,
    options: connectorTypeButtons
  }), (0, _helpers.isValidFieldForConnector)(connectorType, 'alertIdConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.alertIdConfig",
    label: i18n.SW_ALERT_ID_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_ALERT_ID,
    options: textOptions,
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    dataTestSubj: "swimlaneAlertIdInput",
    readOnly: readOnly
  }), (0, _helpers.isValidFieldForConnector)(connectorType, 'ruleNameConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.ruleNameConfig",
    label: i18n.SW_RULE_NAME_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_ALERT_ID,
    options: textOptions,
    dataTestSubj: "swimlaneAlertNameInput",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly
  }), (0, _helpers.isValidFieldForConnector)(connectorType, 'severityConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.severityConfig",
    label: i18n.SW_SEVERITY_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_SEVERITY,
    options: textOptions,
    dataTestSubj: "swimlaneSeverityInput",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly
  }), (0, _helpers.isValidFieldForConnector)(connectorType, 'caseIdConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.caseIdConfig",
    label: i18n.SW_CASE_ID_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_CASE_ID,
    options: textOptions,
    dataTestSubj: "swimlaneCaseIdConfig",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly
  }), (0, _helpers.isValidFieldForConnector)(connectorType, 'caseNameConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.caseNameConfig",
    label: i18n.SW_CASE_NAME_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_CASE_NAME,
    options: textOptions,
    dataTestSubj: "swimlaneCaseNameConfig",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly
  }), (0, _helpers.isValidFieldForConnector)(connectorType, 'commentsConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.commentsConfig",
    label: i18n.SW_COMMENTS_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_COMMENTS,
    options: commentsOptions,
    dataTestSubj: "swimlaneCommentsConfig",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly
  }), (0, _helpers.isValidFieldForConnector)(connectorType, 'descriptionConfig') && /*#__PURE__*/_react.default.createElement(MappingField, {
    path: "config.mappings.descriptionConfig",
    label: i18n.SW_DESCRIPTION_FIELD_LABEL,
    validationLabel: i18n.SW_REQUIRED_DESCRIPTION,
    options: textOptions,
    dataTestSubj: "swimlaneDescriptionConfig",
    fieldIdMap: fieldIdMap,
    connectorType: connectorType,
    readOnly: readOnly
  }));
};
const SwimlaneFields = /*#__PURE__*/_react.default.memo(SwimlaneFieldsComponent);
exports.SwimlaneFields = SwimlaneFields;