"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwimlaneConnection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const SwimlaneConnectionComponent = ({
  readOnly
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.apiUrl",
    component: _components.TextField,
    config: {
      label: i18n.SW_API_URL_TEXT_FIELD_LABEL,
      validations: [{
        validator: urlField(i18n.SW_API_URL_INVALID)
      }]
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'swimlaneApiUrlInput',
        readOnly
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.appId",
    component: _components.TextField,
    config: {
      label: i18n.SW_APP_ID_TEXT_FIELD_LABEL,
      validations: [{
        validator: emptyField(i18n.SW_REQUIRED_APP_ID_TEXT)
      }]
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'swimlaneAppIdInput',
        readOnly
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_public.PasswordField, {
    path: "secrets.apiToken",
    label: i18n.SW_API_TOKEN_TEXT_FIELD_LABEL,
    readOnly: readOnly,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: `${docLinks.ELASTIC_WEBSITE_URL}guide/en/kibana/${docLinks.DOC_LINK_VERSION}/swimlane-action-type.html`,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackConnectors.components.swimlane.apiTokenNameHelpLabel",
      defaultMessage: "Provide a Swimlane API Token"
    })),
    "data-test-subj": "swimlaneApiTokenInput"
  }));
};
const SwimlaneConnection = /*#__PURE__*/_react.default.memo(SwimlaneConnectionComponent);
exports.SwimlaneConnection = SwimlaneConnection;