"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SlackParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  errors,
  messageVariables,
  defaultMessage,
  useDefaultMessage
}) => {
  var _errors$channels, _errors$text;
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    channels = [],
    text
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const {
    toasts
  } = (0, _public.useKibana)().notifications;
  (0, _react.useEffect)(() => {
    if (useDefaultMessage || !text) {
      editAction('subActionParams', {
        channels,
        text: defaultMessage
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [defaultMessage, useDefaultMessage]);
  if (!subAction) {
    editAction('subAction', 'postMessage', index);
  }
  if (!subActionParams) {
    editAction('subActionParams', {
      channels,
      text
    }, index);
  }
  const {
    response: {
      channels: channelsInfo
    } = {},
    isLoading: isLoadingChannels,
    error: channelsError
  } = (0, _public.useSubAction)({
    connectorId: actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id,
    subAction: 'getChannels'
  });
  (0, _react.useEffect)(() => {
    if (channelsError) {
      toasts.danger({
        title: _i18n.i18n.translate('xpack.stackConnectors.slack.params.componentError.getChannelsRequestFailed', {
          defaultMessage: 'Failed to retrieve Slack channels list'
        }),
        body: channelsError.message
      });
    }
  }, [toasts, channelsError]);
  const slackChannels = (0, _react.useMemo)(() => {
    var _channelsInfo$filter$;
    return (_channelsInfo$filter$ = channelsInfo === null || channelsInfo === void 0 ? void 0 : channelsInfo.filter(slackChannel => slackChannel.is_channel).map(slackChannel => ({
      label: slackChannel.name
    }))) !== null && _channelsInfo$filter$ !== void 0 ? _channelsInfo$filter$ : [];
  }, [channelsInfo]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [selectedChannels, setSelectedChannels] = (0, _react.useState)(channels !== null && channels !== void 0 ? channels : []);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    numFilters: selectedChannels.length,
    hasActiveFilters: selectedChannels.length > 0,
    numActiveFilters: selectedChannels.length,
    "data-test-subj": "slackChannelsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.slack.params..showChannelsListButton",
    defaultMessage: "Channels"
  }));
  const options = (0, _react.useMemo)(() => slackChannels.map(slackChannel => ({
    label: slackChannel.label,
    ...(selectedChannels.includes(slackChannel.label) ? {
      checked: 'on'
    } : {})
  })), [slackChannels, selectedChannels]);
  const onChange = (0, _react.useCallback)(newOptions => {
    const newSelectedChannels = newOptions.reduce((result, option) => {
      if (option.checked === 'on') {
        result = [...result, option.label];
      }
      return result;
    }, []);
    setSelectedChannels(newSelectedChannels);
    editAction('subActionParams', {
      channels: newSelectedChannels,
      text
    }, index);
  }, [editAction, index, text]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.channels,
    isInvalid: ((_errors$channels = errors.channels) === null || _errors$channels === void 0 ? void 0 : _errors$channels.length) > 0 && channels.length === 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: 'slackChannelsPopover',
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    "data-test-subj": "slackChannelsSelectableList",
    isLoading: isLoadingChannels,
    options: options,
    loadingMessage: _i18n.i18n.translate('xpack.stackConnectors.components.slack.loadingMessage', {
      defaultMessage: 'Loading channels'
    }),
    noMatchesMessage: _i18n.i18n.translate('xpack.stackConnectors.components.slack.noChannelsFound', {
      defaultMessage: 'No channels found'
    }),
    emptyMessage: _i18n.i18n.translate('xpack.stackConnectors.components.slack.noChannelsAvailable', {
      defaultMessage: 'No channels available'
    }),
    onChange: onChange,
    singleSelection: true
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), list))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: (key, value) => editAction('subActionParams', {
      channels,
      text: value
    }, index),
    messageVariables: messageVariables,
    paramsProperty: "webApi",
    inputTargetValue: text,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.slack.messageTextAreaFieldLabel', {
      defaultMessage: 'Message'
    }),
    errors: (_errors$text = errors.text) !== null && _errors$text !== void 0 ? _errors$text : []
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = SlackParamsFields;
module.exports = exports.default;