"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  MESSAGE_NOT_DEFINED: true,
  MESSAGE_NON_WHITESPACE: true,
  LOADING_JSON_EDITOR: true,
  MESSAGE_FIELD_LABEL: true,
  DESCRIPTION_FIELD_LABEL: true,
  USE_JSON_EDITOR_LABEL: true,
  ALERT_FIELDS_LABEL: true,
  JSON_EDITOR_ARIA: true,
  ENTITY_FIELD_LABEL: true,
  TAGS_HELP: true,
  TAGS_FIELD_LABEL: true,
  PRIORITY_LABEL: true,
  PRIORITY_1: true,
  PRIORITY_2: true,
  PRIORITY_3: true,
  PRIORITY_4: true,
  PRIORITY_5: true,
  RULE_TAGS_DESCRIPTION: true
};
exports.USE_JSON_EDITOR_LABEL = exports.TAGS_HELP = exports.TAGS_FIELD_LABEL = exports.RULE_TAGS_DESCRIPTION = exports.PRIORITY_LABEL = exports.PRIORITY_5 = exports.PRIORITY_4 = exports.PRIORITY_3 = exports.PRIORITY_2 = exports.PRIORITY_1 = exports.MESSAGE_NOT_DEFINED = exports.MESSAGE_NON_WHITESPACE = exports.MESSAGE_FIELD_LABEL = exports.LOADING_JSON_EDITOR = exports.JSON_EDITOR_ARIA = exports.ENTITY_FIELD_LABEL = exports.DESCRIPTION_FIELD_LABEL = exports.ALERT_FIELDS_LABEL = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MESSAGE_NOT_DEFINED = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.messageNotDefined', {
  defaultMessage: '[message]: expected value of type [string] but got [undefined]'
});
exports.MESSAGE_NOT_DEFINED = MESSAGE_NOT_DEFINED;
const MESSAGE_NON_WHITESPACE = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.messageNotWhitespace', {
  defaultMessage: '[message]: must be populated with a value other than just whitespace'
});
exports.MESSAGE_NON_WHITESPACE = MESSAGE_NON_WHITESPACE;
const LOADING_JSON_EDITOR = _i18n.i18n.translate('xpack.stackConnectors.sections.ospgenie.loadingJsonEditor', {
  defaultMessage: 'Loading JSON editor'
});
exports.LOADING_JSON_EDITOR = LOADING_JSON_EDITOR;
const MESSAGE_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.messageLabel', {
  defaultMessage: 'Message (required)'
});
exports.MESSAGE_FIELD_LABEL = MESSAGE_FIELD_LABEL;
const DESCRIPTION_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.descriptionLabel', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_FIELD_LABEL = DESCRIPTION_FIELD_LABEL;
const USE_JSON_EDITOR_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.useJsonEditorLabel', {
  defaultMessage: 'Use JSON editor'
});
exports.USE_JSON_EDITOR_LABEL = USE_JSON_EDITOR_LABEL;
const ALERT_FIELDS_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.alertFieldsLabel', {
  defaultMessage: 'Alert fields'
});
exports.ALERT_FIELDS_LABEL = ALERT_FIELDS_LABEL;
const JSON_EDITOR_ARIA = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.jsonEditorAriaLabel', {
  defaultMessage: 'JSON editor'
});
exports.JSON_EDITOR_ARIA = JSON_EDITOR_ARIA;
const ENTITY_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.entityLabel', {
  defaultMessage: 'Entity'
});
exports.ENTITY_FIELD_LABEL = ENTITY_FIELD_LABEL;
const TAGS_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.tagsHelp', {
  defaultMessage: 'Press enter after each tag to begin a new one.'
});
exports.TAGS_HELP = TAGS_HELP;
const TAGS_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.tagsLabel', {
  defaultMessage: 'Opsgenie tags'
});
exports.TAGS_FIELD_LABEL = TAGS_FIELD_LABEL;
const PRIORITY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priorityLabel', {
  defaultMessage: 'Priority'
});
exports.PRIORITY_LABEL = PRIORITY_LABEL;
const PRIORITY_1 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority1', {
  defaultMessage: 'P1-Critical'
});
exports.PRIORITY_1 = PRIORITY_1;
const PRIORITY_2 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority2', {
  defaultMessage: 'P2-High'
});
exports.PRIORITY_2 = PRIORITY_2;
const PRIORITY_3 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority3', {
  defaultMessage: 'P3-Moderate'
});
exports.PRIORITY_3 = PRIORITY_3;
const PRIORITY_4 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority4', {
  defaultMessage: 'P4-Low'
});
exports.PRIORITY_4 = PRIORITY_4;
const PRIORITY_5 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority5', {
  defaultMessage: 'P5-Information'
});
exports.PRIORITY_5 = PRIORITY_5;
const RULE_TAGS_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.ruleTagsDescription', {
  defaultMessage: 'The tags of the rule.'
});
exports.RULE_TAGS_DESCRIPTION = RULE_TAGS_DESCRIPTION;