"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _opsgenie = require("../../../../common/opsgenie");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = [{
  label: _opsgenie.RULE_TAGS_TEMPLATE,
  key: _opsgenie.RULE_TAGS_TEMPLATE,
  'data-test-subj': 'opsgenie-tags-rule-tags',
  value: i18n.RULE_TAGS_DESCRIPTION
}];
const TagsComponent = ({
  onChange,
  values,
  executionMode
}) => {
  const tagOptions = (0, _react.useMemo)(() => values.map(value => getTagAsOption(value)), [values]);
  const onCreateOption = (0, _react.useCallback)(tagValue => {
    const newTags = [...tagOptions, getTagAsOption(tagValue)];
    onChange('tags', newTags.map(tag => tag.label));
  }, [onChange, tagOptions]);
  const onTagsChange = (0, _react.useCallback)(newOptions => {
    onChange('tags', newOptions.map(option => option.label));
  }, [onChange]);
  const renderOption = (0, _react.useCallback)((option, searchValue) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      gutterSize: "none",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, option.label)), option.value && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, option.value)));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-tags-row",
    fullWidth: true,
    label: i18n.TAGS_FIELD_LABEL,
    helpText: i18n.TAGS_HELP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    rowHeight: 50,
    fullWidth: true,
    isClearable: true,
    options: executionMode === _public.ActionConnectorMode.ActionForm ? options : undefined,
    selectedOptions: tagOptions,
    onCreateOption: onCreateOption,
    onChange: onTagsChange,
    "data-test-subj": "opsgenie-tags",
    renderOption: renderOption
  }));
};
TagsComponent.displayName = 'Tags';
const Tags = /*#__PURE__*/_react.default.memo(TagsComponent);
exports.Tags = Tags;
const getTagAsOption = value => ({
  label: value,
  key: value
});