"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetChoices = void 0;
var _react = require("react");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetChoices = ({
  http,
  actionConnector,
  toastNotifications,
  fields,
  onSuccess
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [choices, setChoices] = (0, _react.useState)([]);
  const didCancel = (0, _react.useRef)(false);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const fetchData = (0, _react.useCallback)(async () => {
    if (!actionConnector) {
      setIsLoading(false);
      return;
    }
    try {
      didCancel.current = false;
      abortCtrl.current.abort();
      abortCtrl.current = new AbortController();
      setIsLoading(true);
      const res = await (0, _api.getChoices)({
        http,
        signal: abortCtrl.current.signal,
        connectorId: actionConnector.id,
        fields
      });
      if (!didCancel.current) {
        const data = Array.isArray(res.data) ? res.data : [];
        setIsLoading(false);
        setChoices(data);
        if (res.status && res.status === 'error') {
          var _res$serviceMessage;
          toastNotifications.addDanger({
            title: i18n.CHOICES_API_ERROR,
            text: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
          });
        } else if (onSuccess) {
          onSuccess(data);
        }
      }
    } catch (error) {
      if (!didCancel.current) {
        setIsLoading(false);
        toastNotifications.addDanger({
          title: i18n.CHOICES_API_ERROR,
          text: error.message
        });
      }
    }
  }, [actionConnector, http, fields, onSuccess, toastNotifications]);
  (0, _react.useEffect)(() => {
    fetchData();
    return () => {
      didCancel.current = true;
      abortCtrl.current.abort();
      setIsLoading(false);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    choices,
    isLoading
  };
};
exports.useGetChoices = useGetChoices;