"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OAuth = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const OAuthComponent = ({
  isLoading,
  readOnly,
  pathPrefix = ''
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}config.clientId`,
    component: _components.TextField,
    config: {
      label: i18n.CLIENTID_LABEL,
      validations: [{
        validator: emptyField(i18n.CLIENTID_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-client-id-form-input',
        readOnly,
        isLoading,
        disabled: readOnly || isLoading
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}config.userIdentifierValue`,
    component: _components.TextField,
    config: {
      label: i18n.USER_IDENTIFIER_LABEL,
      validations: [{
        validator: emptyField(i18n.USER_IDENTIFIER_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-user-identifier-form-input',
        readOnly,
        disabled: readOnly || isLoading,
        isLoading
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}config.jwtKeyId`,
    component: _components.TextField,
    config: {
      label: i18n.KEY_ID_LABEL,
      validations: [{
        validator: emptyField(i18n.KEYID_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-jwt-key-id-form-input',
        readOnly,
        disabled: readOnly || isLoading,
        isLoading
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_public.PasswordField, {
    path: `${pathPrefix}secrets.clientSecret`,
    label: i18n.CLIENTSECRET_LABEL,
    readOnly: readOnly,
    "data-test-subj": "connector-servicenow-client-secret-form-input",
    isLoading: isLoading,
    disabled: readOnly || isLoading
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.privateKey",
    component: _components.TextAreaField,
    config: {
      label: i18n.PRIVATE_KEY_LABEL,
      validations: [{
        validator: emptyField(i18n.PRIVATE_KEY_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'connector-servicenow-private-key-form-input',
        disabled: readOnly || isLoading
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_public.PasswordField, {
    path: `${pathPrefix}secrets.privateKeyPassword`,
    label: i18n.PRIVATE_KEY_PASSWORD_LABEL,
    helpText: i18n.PRIVATE_KEY_PASSWORD_HELPER_TEXT,
    validate: false,
    "data-test-subj": "connector-servicenow-private-key-password-form-input",
    readOnly: readOnly,
    isLoading: isLoading,
    disabled: readOnly || isLoading
  }));
};
const OAuth = /*#__PURE__*/(0, _react.memo)(OAuthComponent);
exports.OAuth = OAuth;