"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIssues = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_get_issues = require("./use_get_issues");
var _use_get_single_issue = require("./use_get_single_issue");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIssuesComponent = ({
  selectedValue,
  http,
  toastNotifications,
  actionConnector,
  onChange
}) => {
  const [query, setQuery] = (0, _react.useState)(null);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const [options, setOptions] = (0, _react.useState)([]);
  const {
    isLoading: isLoadingIssues,
    issues
  } = (0, _use_get_issues.useGetIssues)({
    http,
    toastNotifications,
    actionConnector,
    query
  });
  const {
    isLoading: isLoadingSingleIssue,
    issue: singleIssue
  } = (0, _use_get_single_issue.useGetSingleIssue)({
    http,
    toastNotifications,
    actionConnector,
    id: selectedValue
  });
  (0, _react.useEffect)(() => setOptions(issues.map(issue => ({
    label: issue.title,
    value: issue.key
  }))), [issues]);
  (0, _react.useEffect)(() => {
    if (isLoadingSingleIssue || singleIssue == null) {
      return;
    }
    const singleIssueAsOptions = [{
      label: singleIssue.title,
      value: singleIssue.key
    }];
    setOptions(singleIssueAsOptions);
    setSelectedOptions(singleIssueAsOptions);
  }, [singleIssue, isLoadingSingleIssue]);
  const onSearchChange = (0, _react.useCallback)(searchVal => {
    setQuery(searchVal);
  }, []);
  const onChangeComboBox = (0, _react.useCallback)(changedOptions => {
    setSelectedOptions(changedOptions);
    onChange(changedOptions[0].value);
  }, [onChange]);
  const inputPlaceholder = (0, _react.useMemo)(() => isLoadingIssues || isLoadingSingleIssue ? i18n.SEARCH_ISSUES_LOADING : i18n.SEARCH_ISSUES_PLACEHOLDER, [isLoadingIssues, isLoadingSingleIssue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: true,
    fullWidth: true,
    placeholder: inputPlaceholder,
    "data-test-subj": 'search-parent-issues',
    "aria-label": i18n.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL,
    options: options,
    isLoading: isLoadingIssues || isLoadingSingleIssue,
    onSearchChange: onSearchChange,
    selectedOptions: selectedOptions,
    onChange: onChangeComboBox
  });
};
const SearchIssues = /*#__PURE__*/(0, _react.memo)(SearchIssuesComponent);
exports.SearchIssues = SearchIssues;