"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JIRA_TITLE = exports.JIRA_DESC = void 0;
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const JIRA_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.jira.selectMessageText', {
  defaultMessage: 'Create an incident in Jira.'
});
exports.JIRA_DESC = JIRA_DESC;
const JIRA_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.jira.connectorTypeTitle', {
  defaultMessage: 'Jira'
});
exports.JIRA_TITLE = JIRA_TITLE;
function getConnectorType() {
  return {
    id: '.jira',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: JIRA_DESC,
    actionTypeTitle: JIRA_TITLE,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./jira_connectors')))),
    validateParams: async actionParams => {
      var _actionParams$subActi, _actionParams$subActi2, _actionParams$subActi3, _actionParams$subActi4;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        'subActionParams.incident.summary': new Array(),
        'subActionParams.incident.labels': new Array()
      };
      const validationResult = {
        errors
      };
      if (actionParams.subActionParams && actionParams.subActionParams.incident && !((_actionParams$subActi = actionParams.subActionParams.incident.summary) !== null && _actionParams$subActi !== void 0 && _actionParams$subActi.length)) {
        errors['subActionParams.incident.summary'].push(translations.SUMMARY_REQUIRED);
      }
      if ((_actionParams$subActi2 = actionParams.subActionParams) !== null && _actionParams$subActi2 !== void 0 && (_actionParams$subActi3 = _actionParams$subActi2.incident) !== null && _actionParams$subActi3 !== void 0 && (_actionParams$subActi4 = _actionParams$subActi3.labels) !== null && _actionParams$subActi4 !== void 0 && _actionParams$subActi4.length) {
        // Jira do not allows empty spaces on labels. If the label includes a whitespace show an error.
        if (actionParams.subActionParams.incident.labels.some(label => label.match(/\s/g))) errors['subActionParams.incident.labels'].push(translations.LABELS_WHITE_SPACES);
      }
      return validationResult;
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./jira_params'))))
  };
}