"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_LABEL = exports.OPEN_AI = exports.INVALID_ACTION = exports.DOCUMENTATION = exports.BODY_REQUIRED = exports.BODY_INVALID = exports.AZURE_AI = exports.API_URL_LABEL = exports.API_PROVIDER_REQUIRED = exports.API_PROVIDER_LABEL = exports.API_PROVIDER_HEADING = exports.API_KEY_LABEL = exports.ACTION_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiUrlTextFieldLabel', {
  defaultMessage: 'URL'
});
exports.API_URL_LABEL = API_URL_LABEL;
const API_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiKeySecret', {
  defaultMessage: 'API Key'
});
exports.API_KEY_LABEL = API_KEY_LABEL;
const API_PROVIDER_HEADING = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.providerHeading', {
  defaultMessage: 'OpenAI provider'
});
exports.API_PROVIDER_HEADING = API_PROVIDER_HEADING;
const API_PROVIDER_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiProviderLabel', {
  defaultMessage: 'Select an OpenAI provider'
});
exports.API_PROVIDER_LABEL = API_PROVIDER_LABEL;
const OPEN_AI = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.openAi', {
  defaultMessage: 'OpenAI'
});
exports.OPEN_AI = OPEN_AI;
const AZURE_AI = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.azureAi', {
  defaultMessage: 'Azure OpenAI'
});
exports.AZURE_AI = AZURE_AI;
const DOCUMENTATION = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.documentation', {
  defaultMessage: 'documentation'
});
exports.DOCUMENTATION = DOCUMENTATION;
const URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.urlTextFieldLabel', {
  defaultMessage: 'URL'
});
exports.URL_LABEL = URL_LABEL;
const BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.error.requiredGenerativeAiBodyText', {
  defaultMessage: 'Body is required.'
});
exports.BODY_REQUIRED = BODY_REQUIRED;
const BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.invalidBodyText', {
  defaultMessage: 'Body does not have a valid JSON format.'
});
exports.BODY_INVALID = BODY_INVALID;
const ACTION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.requiredActionText', {
  defaultMessage: 'Action is required.'
});
exports.ACTION_REQUIRED = ACTION_REQUIRED;
const INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
exports.INVALID_ACTION = INVALID_ACTION;
const API_PROVIDER_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.error.requiredApiProviderText', {
  defaultMessage: 'API provider is required.'
});
exports.API_PROVIDER_REQUIRED = API_PROVIDER_REQUIRED;