"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var translations = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  indexPatternField,
  emptyField
} = _helpers.fieldValidators;
const getIndexConfig = docLinks => ({
  label: translations.INDEX_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.index.howToBroadenSearchQueryDescription",
    defaultMessage: "Use * to broaden your query."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.alerting.indexAction,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.index.configureIndexHelpLabel",
    defaultMessage: "Configuring index connector."
  }))),
  validations: [{
    validator: emptyField(translations.INDEX_IS_NOT_VALID)
  }, {
    validator: indexPatternField(_i18n.i18n),
    type: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM
  }]
});
const IndexActionConnectorFields = ({
  readOnly
}) => {
  const {
    http,
    docLinks
  } = (0, _public.useKibana)().services;
  const {
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    __internal__
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.executionTimeField', 'config.index', '__internal__.hasTimeFieldCheckbox']
  });
  const {
    index = null
  } = config !== null && config !== void 0 ? config : {};
  const [indexOptions, setIndexOptions] = (0, _react.useState)([]);
  const [timeFieldOptions, setTimeFieldOptions] = (0, _react.useState)([]);
  const [areIndiciesLoading, setAreIndicesLoading] = (0, _react.useState)(false);
  const hasTimeFieldCheckboxDefaultValue = !!getFieldDefaultValue('config.executionTimeField');
  const showTimeFieldCheckbox = index != null && timeFieldOptions.length > 0;
  const showTimeFieldSelect = __internal__ != null ? __internal__.hasTimeFieldCheckbox : false;
  const setTimeFields = fields => {
    if (fields.length > 0) {
      setTimeFieldOptions([_public.firstFieldOption, ...fields]);
    } else {
      setTimeFieldOptions([]);
    }
  };
  const loadIndexOptions = (0, _lodash.debounce)(async search => {
    setAreIndicesLoading(true);
    setIndexOptions(await (0, _public.getIndexOptions)(http, search));
    setAreIndicesLoading(false);
  }, 250);
  (0, _react.useEffect)(() => {
    const indexPatternsFunction = async () => {
      if (index) {
        const currentEsFields = await (0, _public.getFields)(http, [index]);
        if (Array.isArray(currentEsFields)) {
          setTimeFields((0, _public.getTimeFieldOptions)(currentEsFields));
        }
      }
    };
    indexPatternsFunction();
  }, [http, index]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Write to index",
    id: "xpack.stackConnectors.components.index.connectorSectionTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.index",
    config: getIndexConfig(docLinks)
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onComboChange = async options => {
      field.setValue(options.length > 0 ? options[0].value : '');
      const indices = options.map(s => s.value);

      // reset time field and expression fields if indices are deleted
      if (indices.length === 0) {
        setTimeFields([]);
        return;
      }
      const currentEsFields = await (0, _public.getFields)(http, indices);
      setTimeFields((0, _public.getTimeFieldOptions)(currentEsFields));
    };
    const onSearchComboChange = value => {
      if (value !== undefined) {
        field.clearErrors(_hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM);
      }
      loadIndexOptions(value);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "indexConnectorSelectSearchBox",
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.index.indicesToQueryLabel",
        defaultMessage: "Index"
      }),
      isInvalid: isInvalid,
      error: errorMessage,
      helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.index.howToBroadenSearchQueryDescription",
        defaultMessage: "Use * to broaden your query."
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.alerting.indexAction,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.index.configureIndexHelpLabel",
        defaultMessage: "Configuring index connector."
      })))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      async: true,
      isLoading: areIndiciesLoading,
      isInvalid: isInvalid,
      noSuggestions: !indexOptions.length,
      options: indexOptions,
      "data-test-subj": "connectorIndexesComboBox",
      "data-testid": "connectorIndexesComboBox",
      selectedOptions: index ? [{
        value: index,
        label: index
      }] : [],
      isDisabled: readOnly,
      onChange: onComboChange,
      onSearchChange: onSearchComboChange
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.refresh",
    component: _components.ToggleField,
    config: {
      defaultValue: false
    },
    componentProps: {
      euiFieldProps: {
        label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.stackConnectors.components.index.refreshLabel",
          defaultMessage: "Refresh index"
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          position: "right",
          type: "questionInCircle",
          content: translations.REFRESH_FIELD_TOGGLE_TOOLTIP
        })),
        disabled: readOnly,
        'data-test-subj': 'indexRefreshCheckbox'
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showTimeFieldCheckbox ? /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.hasTimeFieldCheckbox",
    component: _components.ToggleField,
    config: {
      defaultValue: hasTimeFieldCheckboxDefaultValue
    },
    componentProps: {
      euiFieldProps: {
        label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.stackConnectors.components.index.defineTimeFieldLabel",
          defaultMessage: "Define time field for each document"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          position: "right",
          type: "questionInCircle",
          content: translations.SHOW_TIME_FIELD_TOGGLE_TOOLTIP
        })),
        disabled: readOnly,
        'data-test-subj': 'hasTimeFieldCheckbox'
      }
    }
  }) : null, showTimeFieldSelect ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.executionTimeField",
    component: _components.SelectField,
    config: {
      label: translations.EXECUTION_TIME_LABEL
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'executionTimeFieldSelect',
        options: timeFieldOptions,
        fullWidth: true,
        readOnly
      }
    }
  })) : null);
};

// eslint-disable-next-line import/no-default-export
exports.default = IndexActionConnectorFields;
module.exports = exports.default;