"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERNAME_REQUIRED = exports.USERNAME_LABEL = exports.TO_CC_REQUIRED = exports.TENANT_ID_REQUIRED = exports.TENANT_ID_LABEL = exports.SUBJECT_REQUIRED = exports.SERVICE_REQUIRED = exports.SERVICE_LABEL = exports.SENDER_REQUIRED = exports.SECURE_LABEL = exports.PORT_REQUIRED = exports.PORT_LABEL = exports.PORT_INVALID = exports.PASSWORD_LABEL = exports.MESSAGE_REQUIRED = exports.HOST_REQUIRED = exports.HOST_LABEL = exports.HAS_AUTH_LABEL = exports.FROM_LABEL = exports.CLIENT_SECRET_LABEL = exports.CLIENT_ID_REQUIRED = exports.CLIENT_ID_LABEL = void 0;
exports.getInvalidEmailAddress = getInvalidEmailAddress;
exports.getNotAllowedEmailAddress = getNotAllowedEmailAddress;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USERNAME_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.userTextFieldLabel', {
  defaultMessage: 'Username'
});
exports.USERNAME_LABEL = USERNAME_LABEL;
const PASSWORD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.passwordFieldLabel', {
  defaultMessage: 'Password'
});
exports.PASSWORD_LABEL = PASSWORD_LABEL;
const FROM_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.fromTextFieldLabel', {
  defaultMessage: 'Sender'
});
exports.FROM_LABEL = FROM_LABEL;
const SERVICE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.serviceTextFieldLabel', {
  defaultMessage: 'Service'
});
exports.SERVICE_LABEL = SERVICE_LABEL;
const TENANT_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.tenantIdFieldLabel', {
  defaultMessage: 'Tenant ID'
});
exports.TENANT_ID_LABEL = TENANT_ID_LABEL;
const CLIENT_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.clientIdFieldLabel', {
  defaultMessage: 'Client ID'
});
exports.CLIENT_ID_LABEL = CLIENT_ID_LABEL;
const CLIENT_SECRET_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.clientSecretTextFieldLabel', {
  defaultMessage: 'Client Secret'
});
exports.CLIENT_SECRET_LABEL = CLIENT_SECRET_LABEL;
const HOST_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.hostTextFieldLabel', {
  defaultMessage: 'Host'
});
exports.HOST_LABEL = HOST_LABEL;
const PORT_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.portTextFieldLabel', {
  defaultMessage: 'Port'
});
exports.PORT_LABEL = PORT_LABEL;
const SECURE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.secureSwitchLabel', {
  defaultMessage: 'Secure'
});
exports.SECURE_LABEL = SECURE_LABEL;
const HAS_AUTH_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.hasAuthSwitchLabel', {
  defaultMessage: 'Require authentication for this server'
});
exports.HAS_AUTH_LABEL = HAS_AUTH_LABEL;
const SENDER_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredFromText', {
  defaultMessage: 'Sender is required.'
});
exports.SENDER_REQUIRED = SENDER_REQUIRED;
const CLIENT_ID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredClientIdText', {
  defaultMessage: 'Client ID is required.'
});
exports.CLIENT_ID_REQUIRED = CLIENT_ID_REQUIRED;
const TENANT_ID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredTenantIdText', {
  defaultMessage: 'Tenant ID is required.'
});
exports.TENANT_ID_REQUIRED = TENANT_ID_REQUIRED;
const PORT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredPortText', {
  defaultMessage: 'Port is required.'
});
exports.PORT_REQUIRED = PORT_REQUIRED;
const PORT_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.invalidPortText', {
  defaultMessage: 'Port is invalid.'
});
exports.PORT_INVALID = PORT_INVALID;
const SERVICE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredServiceText', {
  defaultMessage: 'Service is required.'
});
exports.SERVICE_REQUIRED = SERVICE_REQUIRED;
const HOST_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredHostText', {
  defaultMessage: 'Host is required.'
});
exports.HOST_REQUIRED = HOST_REQUIRED;
const USERNAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredAuthUserNameText', {
  defaultMessage: 'Username is required.'
});
exports.USERNAME_REQUIRED = USERNAME_REQUIRED;
const TO_CC_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredEntryText', {
  defaultMessage: 'No To, Cc, or Bcc entry.  At least one entry is required.'
});
exports.TO_CC_REQUIRED = TO_CC_REQUIRED;
const MESSAGE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredMessageText', {
  defaultMessage: 'Message is required.'
});
exports.MESSAGE_REQUIRED = MESSAGE_REQUIRED;
const SUBJECT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredSubjectText', {
  defaultMessage: 'Subject is required.'
});
exports.SUBJECT_REQUIRED = SUBJECT_REQUIRED;
function getInvalidEmailAddress(email) {
  return _i18n.i18n.translate('xpack.stackConnectors.components.email.error.invalidEmail', {
    defaultMessage: 'Email address {email} is not valid.',
    values: {
      email
    }
  });
}
function getNotAllowedEmailAddress(email) {
  return _i18n.i18n.translate('xpack.stackConnectors.components.email.error.notAllowed', {
    defaultMessage: 'Email address {email} is not allowed.',
    values: {
      email
    }
  });
}