"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.HTTP_VERBS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _steps = require("./steps");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HTTP_VERBS = ['post', 'put', 'patch'];
exports.HTTP_VERBS = HTTP_VERBS;
const fields = {
  step1: ['config.hasAuth', 'secrets.user', 'secrets.password', '__internal__.hasHeaders', 'config.headers'],
  step2: ['config.createIncidentMethod', 'config.createIncidentUrl', 'config.createIncidentJson', 'config.createIncidentResponseKey'],
  step3: ['config.getIncidentUrl', 'config.getIncidentResponseExternalTitleKey', 'config.viewIncidentUrl'],
  step4: ['config.updateIncidentMethod', 'config.updateIncidentUrl', 'config.updateIncidentJson', 'config.createCommentMethod', 'config.createCommentUrl', 'config.createCommentJson']
};
const CasesWebhookActionConnectorFields = ({
  readOnly
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  const {
    isValid,
    getFields,
    validateFields
  } = (0, _hook_form_lib.useFormContext)();
  const [currentStep, setCurrentStep] = (0, _react.useState)(1);
  const [status, setStatus] = (0, _react.useState)({
    step1: 'incomplete',
    step2: 'incomplete',
    step3: 'incomplete',
    step4: 'incomplete'
  });
  const updateStatus = (0, _react.useCallback)(async () => {
    const steps = [1, 2, 3, 4];
    const currentFields = getFields();
    const statuses = steps.map(index => {
      if (typeof isValid !== 'undefined' && !isValid) {
        const fieldsToValidate = fields[`step${index}`];
        // submit validation fields have already been through validator
        // so we can look at the isValid property from `getFields()`
        const areFieldsValid = fieldsToValidate.every(field => currentFields[field] !== undefined ? currentFields[field].isValid : true);
        return {
          [`step${index}`]: areFieldsValid ? 'complete' : 'danger'
        };
      }
      return {
        [`step${index}`]: currentStep === index ? 'current' : currentStep > index ? 'complete' : 'incomplete'
      };
    });
    setStatus(statuses.reduce((acc, i) => ({
      ...acc,
      ...i
    }), {}));
  }, [currentStep, getFields, isValid]);
  (0, _react.useEffect)(() => {
    updateStatus();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isValid, currentStep]);
  const onNextStep = (0, _react.useCallback)(async selectedStep => {
    const nextStep = selectedStep != null ? selectedStep : currentStep === 4 ? currentStep : currentStep + 1;
    const fieldsToValidate = nextStep === 2 ? fields.step1 : nextStep === 3 ? [...fields.step1, ...fields.step2] : nextStep === 4 ? [...fields.step1, ...fields.step2, ...fields.step3] : [];
    // step validation needs async call in order to run each field through validator
    const {
      areFieldsValid
    } = await validateFields(fieldsToValidate);
    if (!areFieldsValid) {
      setStatus(currentStatus => ({
        ...currentStatus,
        [`step${currentStep}`]: 'danger'
      }));
      return;
    }
    if (nextStep < 5) {
      setCurrentStep(nextStep);
    }
  }, [currentStep, validateFields]);
  const horizontalSteps = (0, _react.useMemo)(() => [{
    title: i18n.STEP_1,
    status: status.step1,
    onClick: () => setCurrentStep(1),
    ['data-test-subj']: `horizontalStep1-${status.step1}`
  }, {
    title: i18n.STEP_2,
    status: status.step2,
    onClick: () => onNextStep(2),
    ['data-test-subj']: `horizontalStep2-${status.step2}`
  }, {
    title: i18n.STEP_3,
    status: status.step3,
    onClick: () => onNextStep(3),
    ['data-test-subj']: `horizontalStep3-${status.step3}`
  }, {
    title: i18n.STEP_4,
    status: status.step4,
    onClick: () => onNextStep(4),
    ['data-test-subj']: `horizontalStep4-${status.step4}`
  }], [onNextStep, status]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: horizontalSteps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${docLinks.ELASTIC_WEBSITE_URL}guide/en/kibana/${docLinks.DOC_LINK_VERSION}/cases-webhook-action-type.html`,
    target: "_blank"
  }, i18n.DOC_LINK), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_steps.AuthStep, {
    readOnly: readOnly,
    display: currentStep === 1
  }), /*#__PURE__*/_react.default.createElement(_steps.CreateStep, {
    readOnly: readOnly,
    display: currentStep === 2
  }), /*#__PURE__*/_react.default.createElement(_steps.GetStep, {
    readOnly: readOnly,
    display: currentStep === 3
  }), /*#__PURE__*/_react.default.createElement(_steps.UpdateStep, {
    readOnly: readOnly,
    display: currentStep === 4
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "flexStart",
    direction: "rowReverse"
  }, currentStep < 4 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 160
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "casesWebhookNext",
    fill: true,
    iconSide: "right",
    iconType: "arrowRight",
    onClick: () => onNextStep()
  }, i18n.NEXT)), currentStep > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 160
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "casesWebhookBack",
    iconSide: "left",
    iconType: "arrowLeft",
    onClick: () => onNextStep(currentStep - 1)
  }, i18n.PREVIOUS))));
};

// eslint-disable-next-line import/no-default-export
exports.default = CasesWebhookActionConnectorFields;