"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IndexThresholdRuleTypeExpression = exports.DEFAULT_VALUES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _visualization = require("./visualization");
require("./expression.scss");
var _index_select_popover = require("../components/index_select_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_VALUES = {
  AGGREGATION_TYPE: 'count',
  TERM_SIZE: 5,
  THRESHOLD_COMPARATOR: _public2.COMPARATORS.GREATER_THAN,
  TIME_WINDOW_SIZE: 5,
  TIME_WINDOW_UNIT: 'm',
  THRESHOLD: [1000],
  GROUP_BY: 'all'
};
exports.DEFAULT_VALUES = DEFAULT_VALUES;
const expressionFieldsWithValidation = ['index', 'timeField', 'aggField', 'termSize', 'termField', 'threshold0', 'threshold1', 'timeWindowSize'];
function isString(value) {
  return typeof value === 'string';
}

// normalize the `index` parameter to be a string array
function indexParamToArray(index) {
  if (!index) return [];
  return isString(index) ? [index] : index;
}
const IndexThresholdRuleTypeExpression = ({
  ruleParams,
  ruleInterval,
  setRuleParams,
  setRuleProperty,
  errors,
  charts,
  data
}) => {
  const {
    index,
    timeField,
    aggType,
    aggField,
    groupBy,
    termSize,
    termField,
    thresholdComparator,
    threshold,
    timeWindowSize,
    timeWindowUnit,
    filterKuery
  } = ruleParams;
  const indexArray = indexParamToArray(index);
  const {
    http
  } = (0, _public.useKibana)().services;
  const [esFields, setEsFields] = (0, _react.useState)([]);
  const hasExpressionErrors = !!Object.keys(errors).find(errorKey => expressionFieldsWithValidation.includes(errorKey) && errors[errorKey].length >= 1 && ruleParams[errorKey] !== undefined);
  const cannotShowVisualization = !!Object.keys(errors).find(errorKey => expressionFieldsWithValidation.includes(errorKey) && errors[errorKey].length >= 1);
  const expressionErrorMessage = _i18n.i18n.translate('xpack.stackAlerts.threshold.ui.alertParams.fixErrorInExpressionBelowValidationMessage', {
    defaultMessage: 'Expression contains errors.'
  });
  const setDefaultExpressionValues = async () => {
    setRuleProperty('params', {
      ...ruleParams,
      aggType: aggType !== null && aggType !== void 0 ? aggType : DEFAULT_VALUES.AGGREGATION_TYPE,
      termSize: termSize !== null && termSize !== void 0 ? termSize : DEFAULT_VALUES.TERM_SIZE,
      thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : DEFAULT_VALUES.THRESHOLD_COMPARATOR,
      timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : DEFAULT_VALUES.TIME_WINDOW_SIZE,
      timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : DEFAULT_VALUES.TIME_WINDOW_UNIT,
      groupBy: groupBy !== null && groupBy !== void 0 ? groupBy : DEFAULT_VALUES.GROUP_BY,
      threshold: threshold !== null && threshold !== void 0 ? threshold : DEFAULT_VALUES.THRESHOLD
    });
    if (indexArray.length > 0) {
      await refreshEsFields(indexArray);
    }
  };
  const refreshEsFields = async indices => {
    const currentEsFields = await (0, _public2.getFields)(http, indices);
    setEsFields(currentEsFields);
  };
  const handleFilterChange = (0, _react.useCallback)(e => {
    setRuleParams('filterKuery', e.target.value || undefined);
  }, [setRuleParams]);
  (0, _react.useEffect)(() => {
    setDefaultExpressionValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, hasExpressionErrors ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    title: expressionErrorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.threshold.ui.selectIndex",
    defaultMessage: "Select an index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_index_select_popover.IndexSelectPopover, {
    index: indexArray,
    "data-test-subj": "indexSelectPopover",
    esFields: esFields,
    timeField: timeField,
    errors: errors,
    onIndexChange: async indices => {
      setRuleParams('index', indices);

      // reset expression fields if indices are deleted
      if (indices.length === 0) {
        setRuleProperty('params', {
          ...ruleParams,
          index: indices,
          aggType: DEFAULT_VALUES.AGGREGATION_TYPE,
          termSize: DEFAULT_VALUES.TERM_SIZE,
          thresholdComparator: DEFAULT_VALUES.THRESHOLD_COMPARATOR,
          timeWindowSize: DEFAULT_VALUES.TIME_WINDOW_SIZE,
          timeWindowUnit: DEFAULT_VALUES.TIME_WINDOW_UNIT,
          groupBy: DEFAULT_VALUES.GROUP_BY,
          threshold: DEFAULT_VALUES.THRESHOLD,
          timeField: ''
        });
      } else {
        await refreshEsFields(indices);
      }
    },
    onTimeFieldChange: updatedTimeField => setRuleParams('timeField', updatedTimeField)
  }), /*#__PURE__*/_react.default.createElement(_public2.WhenExpression, {
    display: "fullWidth",
    "data-test-subj": "whenExpression",
    aggType: aggType !== null && aggType !== void 0 ? aggType : DEFAULT_VALUES.AGGREGATION_TYPE,
    onChangeSelectedAggType: selectedAggType => setRuleParams('aggType', selectedAggType)
  }), aggType && _public2.builtInAggregationTypes[aggType].fieldRequired ? /*#__PURE__*/_react.default.createElement(_public2.OfExpression, {
    aggField: aggField,
    "data-test-subj": "aggTypeExpression",
    fields: esFields,
    aggType: aggType,
    errors: errors,
    display: "fullWidth",
    onChangeSelectedAggField: selectedAggField => setRuleParams('aggField', selectedAggField)
  }) : null, /*#__PURE__*/_react.default.createElement(_public2.GroupByExpression, {
    groupBy: groupBy || DEFAULT_VALUES.GROUP_BY,
    "data-test-subj": "groupByExpression",
    termField: termField,
    termSize: termSize,
    errors: errors,
    fields: esFields,
    display: "fullWidth",
    onChangeSelectedGroupBy: selectedGroupBy => setRuleParams('groupBy', selectedGroupBy),
    onChangeSelectedTermField: selectedTermField => setRuleParams('termField', selectedTermField),
    onChangeSelectedTermSize: selectedTermSize => setRuleParams('termSize', selectedTermSize)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.threshold.ui.conditionPrompt",
    defaultMessage: "Define the condition"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public2.ThresholdExpression, {
    thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    threshold: threshold,
    "data-test-subj": "thresholdExpression",
    errors: errors,
    display: "fullWidth",
    popupPosition: 'upLeft',
    onChangeSelectedThreshold: selectedThresholds => setRuleParams('threshold', selectedThresholds),
    onChangeSelectedThresholdComparator: selectedThresholdComparator => setRuleParams('thresholdComparator', selectedThresholdComparator)
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    "data-test-subj": "forLastExpression",
    popupPosition: 'upLeft',
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : DEFAULT_VALUES.TIME_WINDOW_UNIT,
    display: "fullWidth",
    errors: errors,
    onChangeWindowSize: selectedWindowSize => setRuleParams('timeWindowSize', selectedWindowSize),
    onChangeWindowUnit: selectedWindowUnit => setRuleParams('timeWindowUnit', selectedWindowUnit)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.threshold.ui.filterTitle",
    defaultMessage: "Filter (Optional)"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.stackAlerts.threshold.ui.filterKQLHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alert trigger.'
    }),
    fullWidth: true,
    display: "rowCompressed",
    isInvalid: errors.filterKuery.length > 0,
    error: errors.filterKuery
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "filterKuery",
    onChange: handleFilterChange,
    value: filterKuery,
    fullWidth: true,
    isInvalid: errors.filterKuery.length > 0
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
    className: "actAlertVisualization__chart"
  }, cannotShowVisualization ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "visualizationPlaceholder",
    iconType: "visBarVertical",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.threshold.ui.previewAlertVisualizationDescription",
      defaultMessage: "Complete the expression to generate a preview."
    }))
  })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualization.ThresholdVisualization, {
    "data-test-subj": "thresholdVisualization",
    ruleParams: ruleParams,
    alertInterval: ruleInterval,
    aggregationTypes: _public2.builtInAggregationTypes,
    comparators: _public2.builtInComparators,
    charts: charts,
    dataFieldsFormats: data.fieldFormats
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.IndexThresholdRuleTypeExpression = IndexThresholdRuleTypeExpression;