"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateExpression = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateExpression = alertParams => {
  const {
    index,
    geoField,
    entity,
    dateField,
    boundaryType,
    boundaryIndexTitle,
    boundaryGeoField
  } = alertParams;
  const validationResult = {
    errors: {}
  };
  const errors = {
    index: new Array(),
    indexId: new Array(),
    geoField: new Array(),
    entity: new Array(),
    dateField: new Array(),
    boundaryType: new Array(),
    boundaryIndexTitle: new Array(),
    boundaryIndexId: new Array(),
    boundaryGeoField: new Array()
  };
  validationResult.errors = errors;
  if (!index) {
    errors.index.push(_i18n.i18n.translate('xpack.stackAlerts.geoContainment.error.requiredIndexTitleText', {
      defaultMessage: 'Data view is required.'
    }));
  }
  if (!geoField) {
    errors.geoField.push(_i18n.i18n.translate('xpack.stackAlerts.geoContainment.error.requiredGeoFieldText', {
      defaultMessage: 'Geo field is required.'
    }));
  }
  if (!entity) {
    errors.entity.push(_i18n.i18n.translate('xpack.stackAlerts.geoContainment.error.requiredEntityText', {
      defaultMessage: 'Entity is required.'
    }));
  }
  if (!dateField) {
    errors.dateField.push(_i18n.i18n.translate('xpack.stackAlerts.geoContainment.error.requiredDateFieldText', {
      defaultMessage: 'Date field is required.'
    }));
  }
  if (!boundaryType) {
    errors.boundaryType.push(_i18n.i18n.translate('xpack.stackAlerts.geoContainment.error.requiredBoundaryTypeText', {
      defaultMessage: 'Boundary type is required.'
    }));
  }
  if (!boundaryIndexTitle) {
    errors.boundaryIndexTitle.push(_i18n.i18n.translate('xpack.stackAlerts.geoContainment.error.requiredBoundaryIndexTitleText', {
      defaultMessage: 'Boundary data view title is required.'
    }));
  }
  if (!boundaryGeoField) {
    errors.boundaryGeoField.push(_i18n.i18n.translate('xpack.stackAlerts.geoContainment.error.requiredBoundaryGeoFieldText', {
      defaultMessage: 'Boundary geo field is required.'
    }));
  }
  return validationResult;
};
exports.validateExpression = validateExpression;