"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GeoContainmentAlertTypeExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _boundary_index_expression = require("./expressions/boundary_index_expression");
var _entity_by_expression = require("./expressions/entity_by_expression");
var _entity_index_expression = require("./expressions/entity_index_expression");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_VALUES = {
  TRACKING_EVENT: '',
  ENTITY: '',
  INDEX: '',
  INDEX_ID: '',
  DATE_FIELD: '',
  BOUNDARY_TYPE: 'entireIndex',
  // Only one supported currently. Will eventually be more
  GEO_FIELD: '',
  BOUNDARY_INDEX: '',
  BOUNDARY_INDEX_ID: '',
  BOUNDARY_GEO_FIELD: '',
  BOUNDARY_NAME_FIELD: '',
  DELAY_OFFSET_WITH_UNITS: '0m'
};
function validateQuery(query) {
  try {
    // eslint-disable-next-line @typescript-eslint/no-unused-expressions
    query.language === 'kuery' ? (0, _esQuery.fromKueryExpression)(query.query) : (0, _esQuery.luceneStringToDsl)(query.query);
  } catch (err) {
    return false;
  }
  return true;
}
const GeoContainmentAlertTypeExpression = ({
  ruleParams,
  ruleInterval,
  setRuleParams,
  setRuleProperty,
  errors,
  data,
  unifiedSearch
}) => {
  const {
    index,
    indexId,
    indexQuery,
    geoField,
    entity,
    dateField,
    boundaryType,
    boundaryIndexTitle,
    boundaryIndexId,
    boundaryIndexQuery,
    boundaryGeoField,
    boundaryNameField
  } = ruleParams;
  const {
    http,
    docLinks,
    uiSettings,
    notifications,
    storage,
    usageCollection,
    dataViews
  } = (0, _public2.useKibana)().services;
  const [indexPattern, _setIndexPattern] = (0, _react.useState)({
    id: '',
    title: ''
  });
  const setIndexPattern = _indexPattern => {
    if (_indexPattern) {
      _setIndexPattern(_indexPattern);
      if (_indexPattern.title) {
        setRuleParams('index', _indexPattern.title);
      }
      if (_indexPattern.id) {
        setRuleParams('indexId', _indexPattern.id);
      }
    }
  };
  const [indexQueryInput, setIndexQueryInput] = (0, _react.useState)(indexQuery || {
    query: '',
    language: 'kuery'
  });
  const [boundaryIndexPattern, _setBoundaryIndexPattern] = (0, _react.useState)({
    id: '',
    title: ''
  });
  const setBoundaryIndexPattern = _indexPattern => {
    if (_indexPattern) {
      _setBoundaryIndexPattern(_indexPattern);
      if (_indexPattern.title) {
        setRuleParams('boundaryIndexTitle', _indexPattern.title);
      }
      if (_indexPattern.id) {
        setRuleParams('boundaryIndexId', _indexPattern.id);
      }
    }
  };
  const [boundaryIndexQueryInput, setBoundaryIndexQueryInput] = (0, _react.useState)(boundaryIndexQuery || {
    query: '',
    language: 'kuery'
  });
  const hasExpressionErrors = false;
  const expressionErrorMessage = _i18n.i18n.translate('xpack.stackAlerts.geoContainment.fixErrorInExpressionBelowValidationMessage', {
    defaultMessage: 'Expression contains errors.'
  });
  (0, _react.useEffect)(() => {
    const initToDefaultParams = async () => {
      setRuleProperty('params', {
        ...ruleParams,
        index: index !== null && index !== void 0 ? index : DEFAULT_VALUES.INDEX,
        indexId: indexId !== null && indexId !== void 0 ? indexId : DEFAULT_VALUES.INDEX_ID,
        entity: entity !== null && entity !== void 0 ? entity : DEFAULT_VALUES.ENTITY,
        dateField: dateField !== null && dateField !== void 0 ? dateField : DEFAULT_VALUES.DATE_FIELD,
        boundaryType: boundaryType !== null && boundaryType !== void 0 ? boundaryType : DEFAULT_VALUES.BOUNDARY_TYPE,
        geoField: geoField !== null && geoField !== void 0 ? geoField : DEFAULT_VALUES.GEO_FIELD,
        boundaryIndexTitle: boundaryIndexTitle !== null && boundaryIndexTitle !== void 0 ? boundaryIndexTitle : DEFAULT_VALUES.BOUNDARY_INDEX,
        boundaryIndexId: boundaryIndexId !== null && boundaryIndexId !== void 0 ? boundaryIndexId : DEFAULT_VALUES.BOUNDARY_INDEX_ID,
        boundaryGeoField: boundaryGeoField !== null && boundaryGeoField !== void 0 ? boundaryGeoField : DEFAULT_VALUES.BOUNDARY_GEO_FIELD,
        boundaryNameField: boundaryNameField !== null && boundaryNameField !== void 0 ? boundaryNameField : DEFAULT_VALUES.BOUNDARY_NAME_FIELD
      });
      if (!data.indexPatterns) {
        return;
      }
      if (indexId) {
        const _indexPattern = await data.indexPatterns.get(indexId);
        setIndexPattern(_indexPattern);
      }
      if (boundaryIndexId) {
        const _boundaryIndexPattern = await data.indexPatterns.get(boundaryIndexId);
        setBoundaryIndexPattern(_boundaryIndexPattern);
      }
    };
    initToDefaultParams();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, hasExpressionErrors ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    title: expressionErrorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.geoContainment.selectEntity",
    defaultMessage: "Select entity"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_entity_index_expression.EntityIndexExpression, {
    dateField: dateField,
    geoField: geoField,
    errors: errors,
    setAlertParamsDate: _date => setRuleParams('dateField', _date),
    setAlertParamsGeoField: _geoField => setRuleParams('geoField', _geoField),
    setRuleProperty: setRuleProperty,
    setIndexPattern: setIndexPattern,
    indexPattern: indexPattern,
    isInvalid: !indexId || !dateField || !geoField,
    data: data,
    unifiedSearch: unifiedSearch
  }), /*#__PURE__*/_react.default.createElement(_entity_by_expression.EntityByExpression, {
    errors: errors,
    entity: entity,
    setAlertParamsEntity: entityName => setRuleParams('entity', entityName),
    indexFields: indexPattern.fields,
    isInvalid: indexId && dateField && geoField ? !entity : false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    disableAutoFocus: true,
    bubbleSubmitEvent: true,
    indexPatterns: indexPattern ? [indexPattern] : [],
    query: indexQueryInput,
    onChange: query => {
      if (query.language) {
        if (validateQuery(query)) {
          setRuleParams('indexQuery', query);
        }
        setIndexQueryInput(query);
      }
    },
    appName: _constants.STACK_ALERTS_FEATURE_ID,
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      dataViews,
      storage,
      usageCollection
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.geoContainment.selectBoundaryIndex",
    defaultMessage: "Select boundary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_boundary_index_expression.BoundaryIndexExpression, {
    ruleParams: ruleParams,
    errors: errors,
    boundaryIndexPattern: boundaryIndexPattern,
    setBoundaryIndexPattern: setBoundaryIndexPattern,
    setBoundaryGeoField: _geoField => _geoField && setRuleParams('boundaryGeoField', _geoField),
    setBoundaryNameField: _boundaryNameField => _boundaryNameField ? setRuleParams('boundaryNameField', _boundaryNameField) : setRuleParams('boundaryNameField', ''),
    boundaryNameField: boundaryNameField,
    data: data,
    unifiedSearch: unifiedSearch
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    disableAutoFocus: true,
    bubbleSubmitEvent: true,
    indexPatterns: boundaryIndexPattern ? [boundaryIndexPattern] : [],
    query: boundaryIndexQueryInput,
    onChange: query => {
      if (query.language) {
        if (validateQuery(query)) {
          setRuleParams('boundaryIndexQuery', query);
        }
        setBoundaryIndexQueryInput(query);
      }
    },
    appName: _constants.STACK_ALERTS_FEATURE_ID,
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      dataViews,
      storage,
      usageCollection
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.GeoContainmentAlertTypeExpression = GeoContainmentAlertTypeExpression;