"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTriggerUiActionServices = exports.isSearchSourceRule = exports.convertFieldSpecToFieldOption = void 0;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isSearchSourceRule = ruleParams => {
  return ruleParams.searchType === 'searchSource';
};
exports.isSearchSourceRule = isSearchSourceRule;
const convertFieldSpecToFieldOption = fieldSpec => {
  return (fieldSpec !== null && fieldSpec !== void 0 ? fieldSpec : []).filter(spec => spec.isMapped).map(spec => {
    const converted = {
      name: spec.name,
      searchable: spec.searchable,
      aggregatable: spec.aggregatable,
      type: spec.type,
      normalizedType: spec.type
    };
    if (spec.type === 'string') {
      const esType = spec.esTypes && spec.esTypes.length > 0 ? spec.esTypes[0] : spec.type;
      converted.type = esType;
      converted.normalizedType = esType;
    } else if (spec.type === 'number') {
      const esType = spec.esTypes && spec.esTypes.length > 0 ? spec.esTypes[0] : spec.type;
      converted.type = esType;
    }
    return converted;
  });
};
exports.convertFieldSpecToFieldOption = convertFieldSpecToFieldOption;
const useTriggerUiActionServices = () => (0, _public.useKibana)().services;
exports.useTriggerUiActionServices = useTriggerUiActionServices;