"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleCommonExpressions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("@kbn/triggers-actions-ui-plugin/public/common");
var _constants = require("../constants");
var _test_query_row = require("../test_query_row");
var _threshold_help_popover = require("./threshold_help_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleCommonExpressions = ({
  esFields,
  thresholdComparator,
  threshold,
  timeWindowSize,
  timeWindowUnit,
  aggType,
  aggField,
  groupBy,
  termField,
  termSize,
  size,
  errors,
  hasValidationErrors,
  onChangeSelectedAggField,
  onChangeSelectedAggType,
  onChangeSelectedGroupBy,
  onChangeSelectedTermField,
  onChangeSelectedTermSize,
  onChangeThreshold,
  onChangeThresholdComparator,
  onChangeWindowSize,
  onChangeWindowUnit,
  onChangeSizeValue,
  onTestFetch,
  onCopyQuery,
  excludeHitsFromPreviousRun,
  onChangeExcludeHitsFromPreviousRun
}) => {
  const [isExcludeHitsDisabled, setIsExcludeHitsDisabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (groupBy) {
      setIsExcludeHitsDisabled(groupBy !== _common.builtInGroupByTypes.all.value);
    }
  }, [groupBy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.conditionsPrompt",
    defaultMessage: "Set the group, threshold, and time window"
  }), ' ', /*#__PURE__*/_react.default.createElement(_threshold_help_popover.QueryThresholdHelpPopover, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.WhenExpression, {
    display: "fullWidth",
    "data-test-subj": "whenExpression",
    aggType: aggType !== null && aggType !== void 0 ? aggType : _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
    onChangeSelectedAggType: onChangeSelectedAggType
  }), aggType && _public.builtInAggregationTypes[aggType].fieldRequired ? /*#__PURE__*/_react.default.createElement(_public.OfExpression, {
    aggField: aggField,
    "data-test-subj": "aggTypeExpression",
    fields: esFields,
    aggType: aggType,
    errors: errors,
    display: "fullWidth",
    onChangeSelectedAggField: onChangeSelectedAggField
  }) : null, /*#__PURE__*/_react.default.createElement(_public.GroupByExpression, {
    groupBy: groupBy || _constants.DEFAULT_VALUES.GROUP_BY,
    "data-test-subj": "groupByExpression",
    termField: termField,
    termSize: termSize,
    errors: errors,
    fields: esFields,
    display: "fullWidth",
    onChangeSelectedGroupBy: onChangeSelectedGroupBy,
    onChangeSelectedTermField: onChangeSelectedTermField,
    onChangeSelectedTermSize: onChangeSelectedTermSize
  }), /*#__PURE__*/_react.default.createElement(_public.ThresholdExpression, {
    "data-test-subj": "thresholdExpression",
    thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    threshold: threshold !== null && threshold !== void 0 ? threshold : _constants.DEFAULT_VALUES.THRESHOLD,
    errors: errors,
    display: "fullWidth",
    popupPosition: "upLeft",
    onChangeSelectedThreshold: onChangeThreshold,
    onChangeSelectedThresholdComparator: onChangeThresholdComparator
  }), /*#__PURE__*/_react.default.createElement(_public.ForLastExpression, {
    "data-test-subj": "forLastExpression",
    popupPosition: "upLeft",
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
    display: "fullWidth",
    errors: errors,
    onChangeWindowSize: onChangeWindowSize,
    onChangeWindowUnit: onChangeWindowUnit
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.selectSizePrompt",
    defaultMessage: "Set the number of documents to send"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    color: "subdued",
    type: "questionInCircle",
    content: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectSizePrompt.toolTip', {
      defaultMessage: 'Specify the number of documents to pass to the configured actions when the threshold condition is met.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
    description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.sizeExpression', {
      defaultMessage: 'Size'
    }),
    "data-test-subj": "sizeValueExpression",
    value: size,
    errors: errors.size,
    display: "fullWidth",
    popupPosition: "upLeft",
    onChangeSelectedValue: onChangeSizeValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    disabled: isExcludeHitsDisabled,
    "data-test-subj": "excludeHitsFromPreviousRunExpression",
    checked: excludeHitsFromPreviousRun,
    id: "excludeHitsFromPreviousRunExpressionId",
    onChange: event => {
      onChangeExcludeHitsFromPreviousRun(event.target.checked);
    },
    label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.excludePreviousHitsExpression', {
      defaultMessage: 'Exclude matches from previous runs'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_test_query_row.TestQueryRow, {
    fetch: onTestFetch,
    copyQuery: onCopyQuery,
    hasValidationErrors: hasValidationErrors
  }));
};
exports.RuleCommonExpressions = RuleCommonExpressions;