"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryFormTypeChooser = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FORM_TYPE_ITEMS = [{
  formType: _types.SearchType.searchSource,
  label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.kqlOrLuceneFormTypeLabel', {
    defaultMessage: 'KQL or Lucene'
  }),
  description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.kqlOrLuceneFormTypeDescription', {
    defaultMessage: 'Use KQL or Lucene to define a text-based query.'
  })
}, {
  formType: _types.SearchType.esQuery,
  label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.queryDslFormTypeLabel', {
    defaultMessage: 'Query DSL'
  }),
  description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.queryDslFormTypeDescription', {
    defaultMessage: 'Use the Elasticsearch Query DSL to define a query.'
  })
}];
const QueryFormTypeChooser = ({
  searchType,
  onFormTypeSelect
}) => {
  if (searchType) {
    const activeFormTypeItem = FORM_TYPE_ITEMS.find(item => item.formType === searchType);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      "data-test-subj": "selectedRuleFormTypeTitle"
    }, /*#__PURE__*/_react.default.createElement("h5", null, activeFormTypeItem === null || activeFormTypeItem === void 0 ? void 0 : activeFormTypeItem.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "cross",
      color: "danger",
      "data-test-subj": "queryFormTypeChooserCancel",
      "aria-label": _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.cancelSelectionAriaLabel', {
        defaultMessage: 'Cancel selection'
      }),
      onClick: () => onFormTypeSelect(null)
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      "data-test-subj": "selectedRuleFormTypeDescription"
    }, activeFormTypeItem === null || activeFormTypeItem === void 0 ? void 0 : activeFormTypeItem.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": "queryFormTypeChooserTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.selectQueryFormTypeLabel",
    defaultMessage: "Select a query type"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    gutterSize: "m",
    size: "m",
    maxWidth: false
  }, FORM_TYPE_ITEMS.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    wrapText: true,
    key: `form-type-${item.formType}`,
    "data-test-subj": `queryFormType_${item.formType}`,
    color: "primary",
    label: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("strong", null, item.label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, item.description))),
    onClick: () => onFormTypeSelect(item.formType)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.QueryFormTypeChooser = QueryFormTypeChooser;