"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewSelectPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _util = require("../es_query/util");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toDataViewListItem = dataView => {
  return {
    id: dataView.id,
    title: dataView.title,
    name: dataView.name,
    isAdhoc: !dataView.isPersisted()
  };
};
const DataViewSelectPopover = ({
  metadata = {
    adHocDataViewList: [],
    isManagementPage: true
  },
  dataView,
  onSelectDataView,
  onChangeMetaData
}) => {
  var _dataView$getName;
  const {
    dataViews,
    dataViewEditor
  } = (0, _util.useTriggerUiActionServices)();
  const [dataViewItems, setDataViewsItems] = (0, _react.useState)([]);
  const [dataViewPopoverOpen, setDataViewPopoverOpen] = (0, _react.useState)(false);
  const closeDataViewEditor = (0, _react.useRef)();
  const allDataViewItems = (0, _react.useMemo)(() => [...dataViewItems, ...metadata.adHocDataViewList.map(toDataViewListItem)], [dataViewItems, metadata.adHocDataViewList]);
  const closeDataViewPopover = (0, _react.useCallback)(() => setDataViewPopoverOpen(false), []);
  const onChangeDataView = (0, _react.useCallback)(async selectedDataViewId => {
    const selectedDataView = await dataViews.get(selectedDataViewId);
    onSelectDataView(selectedDataView);
    closeDataViewPopover();
  }, [closeDataViewPopover, dataViews, onSelectDataView]);
  const loadPersistedDataViews = (0, _react.useCallback)(async () => {
    const ids = await dataViews.getIds();
    const dataViewsList = await Promise.all(ids.map(id => dataViews.get(id)));
    setDataViewsItems(dataViewsList.map(toDataViewListItem));
  }, [dataViews]);
  const onAddAdHocDataView = (0, _react.useCallback)(adHocDataView => {
    onChangeMetaData({
      ...metadata,
      adHocDataViewList: [...metadata.adHocDataViewList, adHocDataView]
    });
  }, [metadata, onChangeMetaData]);
  const createDataView = (0, _react.useMemo)(() => dataViewEditor.userPermissions.editDataView() ? () => {
    closeDataViewEditor.current = dataViewEditor.openEditor({
      onSave: async createdDataView => {
        if (createdDataView.id) {
          if (!createdDataView.isPersisted()) {
            onAddAdHocDataView(createdDataView);
          }
          await loadPersistedDataViews();
          await onChangeDataView(createdDataView.id);
        }
      },
      allowAdHocDataView: true
    });
  } : undefined, [dataViewEditor, loadPersistedDataViews, onChangeDataView, onAddAdHocDataView]);
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editor when unmounting
      if (closeDataViewEditor.current) {
        closeDataViewEditor.current();
      }
    };
  }, []);
  (0, _react.useEffect)(() => {
    loadPersistedDataViews();
  }, [loadPersistedDataViews]);
  const createDataViewButtonPadding = (0, _eui.useEuiPaddingCSS)('left');
  const onCreateDefaultAdHocDataView = (0, _react.useCallback)(async pattern => {
    var _newDataView$fields$g;
    const newDataView = await dataViews.create({
      title: pattern
    });
    if (((_newDataView$fields$g = newDataView.fields.getByName('@timestamp')) === null || _newDataView$fields$g === void 0 ? void 0 : _newDataView$fields$g.type) === 'date') {
      newDataView.timeFieldName = '@timestamp';
    }
    onAddAdHocDataView(newDataView);
    onChangeDataView(newDataView.id);
  }, [dataViews, onAddAdHocDataView, onChangeDataView]);
  if (!allDataViewItems) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "dataViewPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      display: "columns",
      "data-test-subj": "selectDataViewExpression",
      description: _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.dataViewLabel', {
        defaultMessage: 'data view'
      }),
      value: (_dataView$getName = dataView === null || dataView === void 0 ? void 0 : dataView.getName()) !== null && _dataView$getName !== void 0 ? _dataView$getName : _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.dataViewPlaceholder', {
        defaultMessage: 'Select a data view'
      }),
      isActive: dataViewPopoverOpen,
      onClick: () => {
        setDataViewPopoverOpen(true);
      },
      isInvalid: !(dataView !== null && dataView !== void 0 && dataView.id)
    }),
    isOpen: dataViewPopoverOpen,
    closePopover: closeDataViewPopover,
    ownFocus: true,
    anchorPosition: "downLeft",
    display: "block"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '450px'
    },
    "data-test-subj": "chooseDataViewPopoverContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.dataViewPopoverTitle', {
    defaultMessage: 'Data view'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "closeDataViewPopover",
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.closeDataViewPopoverLabel', {
      defaultMessage: 'Close'
    }),
    onClick: closeDataViewPopover
  })))), /*#__PURE__*/_react.default.createElement(_public.DataViewSelector, {
    currentDataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    dataViewsList: allDataViewItems,
    setPopoverIsOpen: setDataViewPopoverOpen,
    onChangeDataView: onChangeDataView,
    onCreateDefaultAdHocDataView: onCreateDefaultAdHocDataView,
    isTextBasedLangSelected: false
  }), createDataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: createDataViewButtonPadding.s,
    iconType: "plusInCircleFilled",
    "data-test-subj": "chooseDataViewPopover.createDataViewButton",
    onClick: () => {
      closeDataViewPopover();
      createDataView();
    }
  }, _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.dataViewPopover.createDataViewButton', {
    defaultMessage: 'Create a data view'
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.components.ui.alertParams.dataViewPopover.createDataViewButton.noPermissionDescription",
    defaultMessage: "You need additional privileges to create data views. Contact your administrator."
  })))));
};
exports.DataViewSelectPopover = DataViewSelectPopover;