"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesContextWrapperInternal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("./context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getSpacesData(spacesManager, feature) {
  const spaces = await spacesManager.getSpaces({
    includeAuthorizedPurposes: true
  });
  const activeSpace = await spacesManager.getActiveSpace();
  const spacesMap = spaces.map(({
    authorizedPurposes,
    disabledFeatures,
    ...space
  }) => {
    const isActiveSpace = space.id === activeSpace.id;
    const isFeatureDisabled = feature !== undefined && disabledFeatures.includes(feature);
    return {
      ...space,
      ...(isActiveSpace && {
        isActiveSpace
      }),
      ...(isFeatureDisabled && {
        isFeatureDisabled
      }),
      isAuthorizedForPurpose: purpose =>
      // If authorizedPurposes is not present, then Security is disabled; normally in a situation like this we would "fail-secure", but
      // in this case we are dealing with an abstraction over the client-side UI capabilities. There is no chance for privilege
      // escalation here, and the correct behavior is that if Security is disabled, the user is implicitly authorized to do everything.
      authorizedPurposes ? authorizedPurposes[purpose] === true : true
    };
  }).reduce((acc, cur) => acc.set(cur.id, cur), new Map());
  return {
    spacesMap,
    activeSpaceId: activeSpace.id
  };
}
const SpacesContextWrapperInternal = props => {
  const {
    spacesManager,
    getStartServices,
    feature,
    children
  } = props;
  const [context, setContext] = (0, _react.useState)();
  const spacesDataPromise = (0, _react.useMemo)(() => getSpacesData(spacesManager, feature), [spacesManager, feature]);
  (0, _react.useEffect)(() => {
    getStartServices().then(([coreStart]) => {
      const {
        application,
        docLinks,
        notifications
      } = coreStart;
      const services = {
        application,
        docLinks,
        notifications
      };
      setContext((0, _context.createSpacesReactContext)(services, spacesManager, spacesDataPromise));
    });
  }, [getStartServices, spacesDataPromise, spacesManager]);
  if (!context) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(context.Provider, null, children);
};
exports.SpacesContextWrapperInternal = SpacesContextWrapperInternal;