"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.spaceSelectorApp = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const spaceSelectorApp = Object.freeze({
  id: 'space_selector',
  create({
    application,
    getStartServices,
    spacesManager
  }) {
    application.register({
      id: this.id,
      title: _i18n.i18n.translate('xpack.spaces.spaceSelector.appTitle', {
        defaultMessage: 'Select a space'
      }),
      chromeless: true,
      appRoute: '/spaces/space_selector',
      mount: async ({
        element,
        theme$
      }) => {
        const [[coreStart], {
          renderSpaceSelectorApp
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./space_selector')))]);
        return renderSpaceSelectorApp(coreStart.i18n, {
          element,
          theme$
        }, {
          spacesManager,
          serverBasePath: coreStart.http.basePath.serverBasePath,
          customBranding$: coreStart.customBranding.customBranding$
        });
      }
    });
  }
});
exports.spaceSelectorApp = spaceSelectorApp;