"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _advanced_settings = require("./advanced_settings");
var _create_feature_catalogue_entry = require("./create_feature_catalogue_entry");
var _management = require("./management");
var _nav_control = require("./nav_control");
var _space_selector = require("./space_selector");
var _spaces_manager = require("./spaces_manager");
var _ui_api = require("./ui_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SpacesPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "spacesManager", void 0);
    (0, _defineProperty2.default)(this, "spacesApi", void 0);
    (0, _defineProperty2.default)(this, "managementService", void 0);
  }
  setup(core, plugins) {
    this.spacesManager = new _spaces_manager.SpacesManager(core.http);
    this.spacesApi = {
      ui: (0, _ui_api.getUiApi)({
        spacesManager: this.spacesManager,
        getStartServices: core.getStartServices
      }),
      getActiveSpace$: () => this.spacesManager.onActiveSpaceChange$,
      getActiveSpace: () => this.spacesManager.getActiveSpace()
    };
    if (plugins.home) {
      plugins.home.featureCatalogue.register((0, _create_feature_catalogue_entry.createSpacesFeatureCatalogueEntry)());
    }
    if (plugins.management) {
      this.managementService = new _management.ManagementService();
      this.managementService.setup({
        management: plugins.management,
        getStartServices: core.getStartServices,
        spacesManager: this.spacesManager
      });
    }
    if (plugins.advancedSettings) {
      const advancedSettingsService = new _advanced_settings.AdvancedSettingsService();
      advancedSettingsService.setup({
        getActiveSpace: () => this.spacesManager.getActiveSpace(),
        componentRegistry: plugins.advancedSettings.component
      });
    }
    _space_selector.spaceSelectorApp.create({
      getStartServices: core.getStartServices,
      application: core.application,
      spacesManager: this.spacesManager
    });
    return {};
  }
  start(core) {
    (0, _nav_control.initSpacesNavControl)(this.spacesManager, core);
    return this.spacesApi;
  }
  stop() {
    if (this.managementService) {
      this.managementService.stop();
      this.managementService = undefined;
    }
  }
}
exports.SpacesPlugin = SpacesPlugin;