"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.spacesManagementApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const spacesManagementApp = Object.freeze({
  id: 'spaces',
  create({
    getStartServices,
    spacesManager
  }) {
    const title = _i18n.i18n.translate('xpack.spaces.displayName', {
      defaultMessage: 'Spaces'
    });
    return {
      id: this.id,
      order: 2,
      title,
      async mount({
        element,
        theme$,
        setBreadcrumbs,
        history
      }) {
        const [[coreStart, {
          features
        }], {
          SpacesGridPage
        }, {
          ManageSpacePage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./spaces_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_space')))]);
        const spacesFirstBreadcrumb = {
          text: title,
          href: `/`
        };
        const {
          notifications,
          i18n: i18nStart,
          application,
          chrome
        } = coreStart;
        chrome.docTitle.change(title);
        const SpacesGridPageWithBreadcrumbs = () => {
          setBreadcrumbs([{
            ...spacesFirstBreadcrumb,
            href: undefined
          }]);
          return /*#__PURE__*/_react.default.createElement(SpacesGridPage, {
            capabilities: application.capabilities,
            getFeatures: features.getFeatures,
            notifications: notifications,
            spacesManager: spacesManager,
            history: history,
            getUrlForApp: application.getUrlForApp
          });
        };
        const CreateSpacePageWithBreadcrumbs = () => {
          setBreadcrumbs([spacesFirstBreadcrumb, {
            text: _i18n.i18n.translate('xpack.spaces.management.createSpaceBreadcrumb', {
              defaultMessage: 'Create'
            })
          }]);
          return /*#__PURE__*/_react.default.createElement(ManageSpacePage, {
            capabilities: application.capabilities,
            getFeatures: features.getFeatures,
            notifications: notifications,
            spacesManager: spacesManager,
            history: history
          });
        };
        const EditSpacePageWithBreadcrumbs = () => {
          const {
            spaceId
          } = (0, _reactRouterDom.useParams)();
          const onLoadSpace = space => {
            setBreadcrumbs([spacesFirstBreadcrumb, {
              text: space.name
            }]);
          };
          return /*#__PURE__*/_react.default.createElement(ManageSpacePage, {
            capabilities: application.capabilities,
            getFeatures: features.getFeatures,
            notifications: notifications,
            spacesManager: spacesManager,
            spaceId: spaceId,
            onLoadSpace: onLoadSpace,
            history: history
          });
        };
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
          services: coreStart
        }, /*#__PURE__*/_react.default.createElement(i18nStart.Context, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
          theme$: theme$
        }, /*#__PURE__*/_react.default.createElement(_public2.RedirectAppLinks, {
          application: application,
          className: _public.APP_WRAPPER_CLASS
        }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
          history: history
        }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['', '/'],
          exact: true
        }, /*#__PURE__*/_react.default.createElement(SpacesGridPageWithBreadcrumbs, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/create"
        }, /*#__PURE__*/_react.default.createElement(CreateSpacePageWithBreadcrumbs, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit/:spaceId"
        }, /*#__PURE__*/_react.default.createElement(EditSpacePageWithBreadcrumbs, null)))))))), element);
        return () => {
          chrome.docTitle.reset();
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});
exports.spacesManagementApp = spacesManagementApp;