"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _spaces_management_app = require("./spaces_management_app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ManagementService {
  constructor() {
    (0, _defineProperty2.default)(this, "registeredSpacesManagementApp", void 0);
  }
  setup({
    getStartServices,
    management,
    spacesManager
  }) {
    this.registeredSpacesManagementApp = management.sections.section.kibana.registerApp(_spaces_management_app.spacesManagementApp.create({
      getStartServices,
      spacesManager
    }));
  }
  stop() {
    this.disableSpacesApp();
  }
  disableSpacesApp() {
    if (this.registeredSpacesManagementApp) {
      this.registeredSpacesManagementApp.disable();
    }
  }
}
exports.ManagementService = ManagementService;