"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnabledFeatures = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _section_panel = require("../section_panel");
var _feature_table = require("./feature_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnabledFeatures = props => {
  var _services$application, _services$application2, _services$application3, _services$application4;
  const {
    services
  } = (0, _public.useKibana)();
  const canManageRoles = ((_services$application = services.application) === null || _services$application === void 0 ? void 0 : (_services$application2 = _services$application.capabilities.management) === null || _services$application2 === void 0 ? void 0 : (_services$application3 = _services$application2.security) === null || _services$application3 === void 0 ? void 0 : _services$application3.roles) === true;
  return /*#__PURE__*/_react.default.createElement(_section_panel.SectionPanel, {
    title: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.featuresTitle', {
      defaultMessage: 'Features'
    }),
    "data-test-subj": "enabled-features-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.enabledSpaceFeatures.enableFeaturesInSpaceMessage",
    defaultMessage: "Set feature visibility"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.enabledSpaceFeatures.notASecurityMechanismMessage",
    defaultMessage: "Hidden features are removed from the user interface, but not disabled. To secure access to features, {manageRolesLink}.",
    values: {
      manageRolesLink: canManageRoles ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: (_services$application4 = services.application) === null || _services$application4 === void 0 ? void 0 : _services$application4.getUrlForApp('management', {
          path: '/security/roles'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.enabledSpaceFeatures.manageRolesLinkText",
        defaultMessage: "manage security roles"
      })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.enabledSpaceFeatures.manageRolesLinkText",
        defaultMessage: "manage security roles"
      })
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_feature_table.FeatureTable, {
    features: props.features,
    space: props.space,
    onChange: props.onChange
  }))));
};
exports.EnabledFeatures = EnabledFeatures;