"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processImportResponse = processImportResponse;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is derived from the function of the same name in the savedObjectsManagement plugin
function processImportResponse(response) {
  const {
    success,
    errors = [],
    successResults = []
  } = response;
  const failedImports = errors.map(({
    error,
    ...obj
  }) => ({
    obj,
    error
  }));
  return {
    success,
    failedImports,
    successfulImports: successResults
  };
}