"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettingsService = void 0;
var _react = _interopRequireDefault(require("react"));
var _components = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AdvancedSettingsService {
  setup({
    getActiveSpace,
    componentRegistry
  }) {
    const PageTitle = () => /*#__PURE__*/_react.default.createElement(_components.AdvancedSettingsTitle, {
      getActiveSpace: getActiveSpace
    });
    const SubTitle = () => /*#__PURE__*/_react.default.createElement(_components.AdvancedSettingsSubtitle, {
      getActiveSpace: getActiveSpace
    });
    componentRegistry.register(componentRegistry.componentType.PAGE_TITLE_COMPONENT, PageTitle, true);
    componentRegistry.register(componentRegistry.componentType.PAGE_SUBTITLE_COMPONENT, SubTitle, true);
  }
}
exports.AdvancedSettingsService = AdvancedSettingsService;