"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotRestoreUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _http = require("./application/services/http");
var _text = require("./application/services/text");
var _services = require("./application/services");
var _constants2 = require("./application/constants");
var _locator = require("./locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class SnapshotRestoreUIPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "uiMetricService", new _services.UiMetricService(_constants2.UIM_APP_NAME));
    this.initializerContext = initializerContext;
    // Temporary hack to provide the service instances in module files in order to avoid a big refactor
    (0, _http.setUiMetricService)(this.uiMetricService);
  }
  setup(coreSetup, plugins) {
    const config = this.initializerContext.config.get();
    const {
      ui: {
        enabled: isSnapshotRestoreUiEnabled
      }
    } = config;
    if (isSnapshotRestoreUiEnabled) {
      const {
        http
      } = coreSetup;
      const {
        home,
        management,
        usageCollection
      } = plugins;

      // Initialize services
      this.uiMetricService.setup(usageCollection);
      _text.textService.setup(_i18n.i18n);
      _http.httpService.setup(http);
      management.sections.section.data.registerApp({
        id: _constants.PLUGIN.id,
        title: _i18n.i18n.translate('xpack.snapshotRestore.appTitle', {
          defaultMessage: 'Snapshot and Restore'
        }),
        order: 3,
        mount: async params => {
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
          const services = {
            uiMetricService: this.uiMetricService
          };
          return await mountManagementSection(coreSetup, services, config, params);
        }
      });
      if (home) {
        home.featureCatalogue.register({
          id: _constants.PLUGIN.id,
          title: _i18n.i18n.translate('xpack.snapshotRestore.featureCatalogueTitle', {
            defaultMessage: 'Back up and restore'
          }),
          description: _i18n.i18n.translate('xpack.snapshotRestore.featureCatalogueDescription', {
            defaultMessage: 'Save snapshots to a backup repository, and restore to recover index and cluster state.'
          }),
          icon: 'storage',
          path: '/app/management/data/snapshot_restore',
          showOnHomePage: true,
          category: 'admin',
          order: 630
        });
      }
      plugins.share.url.locators.create(new _locator.SnapshotRestoreLocatorDefinition({
        managementAppLocator: plugins.management.locator
      }));
    }
  }
  start() {}
  stop() {}
}
exports.SnapshotRestoreUIPlugin = SnapshotRestoreUIPlugin;