"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiMetricService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _analytics = require("@kbn/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UiMetricService {
  constructor(appName) {
    (0, _defineProperty2.default)(this, "usageCollection", void 0);
    this.appName = appName;
  }
  setup(usageCollection) {
    this.usageCollection = usageCollection;
  }
  track(name) {
    if (!this.usageCollection) {
      // Usage collection might have been disabled in Kibana config.
      return;
    }
    this.usageCollection.reportUiCounter(this.appName, _analytics.METRIC_TYPE.COUNT, name);
  }
  trackUiMetric(eventName) {
    return this.track(eventName);
  }
}
exports.UiMetricService = UiMetricService;