"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshot = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../constants");
var _components = require("../../components");
var _app_context = require("../../app_context");
var _navigation = require("../../services/navigation");
var _http = require("../../services/http");
var _lib = require("../../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RestoreSnapshot = ({
  history
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    repositoryName,
    snapshotId
  } = (0, _lib.useDecodedParams)();

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs('restoreSnapshot');
    _navigation.docTitleService.setTitle('restoreSnapshot');
  }, []);

  // Snapshot details state with default empty snapshot
  const [snapshotDetails, setSnapshotDetails] = (0, _react.useState)({});

  // Load snapshot
  const {
    error: snapshotError,
    isLoading: loadingSnapshot,
    data: snapshotData
  } = (0, _http.useLoadSnapshot)(repositoryName, snapshotId);

  // Update repository state when data is loaded
  (0, _react.useEffect)(() => {
    if (snapshotData) {
      setSnapshotDetails(snapshotData);
    }
  }, [snapshotData]);

  // Saving repository states
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);

  // Execute restore
  const onSave = async restoreSettings => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _http.executeRestore)(repositoryName, snapshotId, restoreSettings);
    if (error) {
      setIsSaving(false);
      setSaveError(error);
    } else {
      // Wait a few seconds before redirecting so that restore information has time to
      // populate into master node
      setTimeout(() => {
        setIsSaving(false);
        history.push(`${_constants.BASE_PATH}/restore_status`);
      }, 5 * 1000);
    }
  };
  const renderLoading = () => {
    return /*#__PURE__*/_react.default.createElement(_components.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreSnapshot.loadingSnapshotDescription",
      defaultMessage: "Loading snapshot details\u2026"
    }));
  };
  const renderError = () => {
    const notFound = snapshotError.status === 404;
    const errorObject = notFound ? {
      data: {
        error: i18n.translate('xpack.snapshotRestore.restoreSnapshot.snapshotNotFoundErrorMessage', {
          defaultMessage: `The snapshot '{snapshot}' does not exist in repository '{repository}'.`,
          values: {
            snapshot: snapshotId,
            repository: repositoryName
          }
        })
      }
    } : snapshotError;
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.restoreSnapshot.loadingSnapshotErrorTitle",
        defaultMessage: "Error loading snapshot details"
      }),
      error: errorObject
    });
  };
  const renderSaveError = () => {
    return saveError ? /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.restoreSnapshot.executeRestoreErrorTitle",
        defaultMessage: "Unable to restore snapshot"
      }),
      error: saveError
    }) : null;
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  if (loadingSnapshot) {
    return renderLoading();
  }
  if (snapshotError) {
    return renderError();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreSnapshotTitle",
      defaultMessage: "Restore '{snapshot}'",
      values: {
        snapshot: snapshotId
      }
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_components.RestoreSnapshotForm, {
    snapshotDetails: snapshotDetails,
    isSaving: isSaving,
    saveError: renderSaveError(),
    clearSaveError: clearSaveError,
    onSave: onSave
  }));
};
exports.RestoreSnapshot = RestoreSnapshot;