"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _queryString = require("query-string");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../../../constants");
var _http = require("../../../services/http");
var _navigation = require("../../../services/navigation");
var _app_context = require("../../../app_context");
var _lib = require("../../../lib");
var _snapshot_details = require("./snapshot_details");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SnapshotList = ({
  location: {
    search
  },
  history
}) => {
  const {
    repositoryName,
    snapshotId
  } = (0, _lib.useDecodedParams)();
  const [listParams, setListParams] = (0, _react.useState)(_lib.DEFAULT_SNAPSHOT_LIST_PARAMS);
  const {
    error,
    isInitialRequest,
    isLoading,
    data: {
      snapshots = [],
      repositories = [],
      policies = [],
      errors = {},
      total: totalSnapshotsCount
    },
    resendRequest: reload
  } = (0, _http.useLoadSnapshots)(listParams);
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const {
    core
  } = (0, _app_context.useAppContext)();
  const closeSnapshotDetails = () => {
    history.push(`${_constants.BASE_PATH}/snapshots`);
  };
  const onSnapshotDeleted = snapshotsDeleted => {
    if (repositoryName && snapshotId && snapshotsDeleted.find(({
      snapshot,
      repository
    }) => snapshot === snapshotId && repository === repositoryName)) {
      closeSnapshotDetails();
    }
    if (snapshotsDeleted.length) {
      reload();
    }
  };
  (0, _shared_imports.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'snapshotRestoreSnapshotTab'
  });

  // Allow deeplinking to list pre-filtered by repository name or by policy name
  (0, _react.useEffect)(() => {
    if (search) {
      const parsedParams = (0, _queryString.parse)(search.replace(/^\?/, ''), {
        sort: false
      });
      const {
        repository,
        policy
      } = parsedParams;
      if (policy) {
        setListParams(prev => ({
          ...prev,
          searchField: 'policyName',
          searchValue: String(policy),
          searchMatch: 'must',
          searchOperator: 'exact'
        }));
        history.replace(`${_constants.BASE_PATH}/snapshots`);
      } else if (repository) {
        setListParams(prev => ({
          ...prev,
          searchField: 'repository',
          searchValue: String(repository),
          searchMatch: 'must',
          searchOperator: 'exact'
        }));
        history.replace(`${_constants.BASE_PATH}/snapshots`);
      }
    }
  }, [listParams, history, search]);

  // Track component loaded
  (0, _react.useEffect)(() => {
    uiMetricService.trackUiMetric(_constants.UIM_SNAPSHOT_LIST_LOAD);
  }, [uiMetricService]);
  let content;

  // display "loading" section only on initial load, after that the table will have a loading indicator
  if (isInitialRequest && isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "snapshotListEmpty"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotList.loadingSnapshotsDescription",
      defaultMessage: "Loading snapshots\u2026"
    })));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotList.loadingSnapshotsErrorMessage",
        defaultMessage: "Error loading snapshots"
      }),
      error: error
    });
  } else if (Object.keys(errors).length && repositories.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_components.RepositoryError, null);
  } else if (repositories.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_components.RepositoryEmptyPrompt, null);
  } else if (totalSnapshotsCount === 0 && !listParams.searchField && !isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_components.SnapshotEmptyPrompt, {
      policiesCount: policies.length
    });
  } else {
    const repositoryErrorsWarning = Object.keys(errors).length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryWarningTitle",
        defaultMessage: "Some repositories contain errors"
      }),
      color: "warning",
      iconType: "warning",
      "data-test-subj": "repositoryErrorsWarning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryWarningDescription",
      defaultMessage: "Snapshots might load slowly. Go to {repositoryLink} to fix the errors.",
      values: {
        repositoryLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToRepositories)()), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryWarningLinkText",
          defaultMessage: "Repositories"
        }))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null;
    content = /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "snapshotList"
    }, repositoryErrorsWarning, /*#__PURE__*/_react.default.createElement(_components.SnapshotTable, {
      snapshots: snapshots,
      repositories: repositories,
      reload: reload,
      onSnapshotDeleted: onSnapshotDeleted,
      listParams: listParams,
      setListParams: setListParams,
      totalItemCount: totalSnapshotsCount,
      isLoading: isLoading
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, repositoryName && snapshotId ? /*#__PURE__*/_react.default.createElement(_snapshot_details.SnapshotDetails, {
    repositoryName: repositoryName,
    snapshotId: snapshotId,
    onClose: closeSnapshotDetails,
    onSnapshotDeleted: onSnapshotDeleted
  }) : null, content);
};
exports.SnapshotList = SnapshotList;