"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _components = require("../../../../components");
var _lib = require("../../../../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_DEBOUNCE_VALUE_MS = 200;
const onlyOneClauseMessage = _i18n.i18n.translate('xpack.snapshotRestore.snapshotList.searchBar.onlyOneClauseMessage', {
  defaultMessage: 'You can only use one clause in the search bar'
});
// for now limit the search bar to snapshot, repository and policyName queries
const searchSchema = {
  strict: true,
  fields: {
    snapshot: {
      type: 'string'
    },
    repository: {
      type: 'string'
    },
    policyName: {
      type: 'string'
    }
  }
};
const SnapshotSearchBar = ({
  listParams,
  setListParams,
  reload,
  selectedItems,
  onSnapshotDeleted,
  repositories
}) => {
  const [cachedListParams, setCachedListParams] = (0, _react.useState)(listParams);
  // send the request after the user has stopped typing
  (0, _useDebounce.default)(() => {
    setListParams(cachedListParams);
  }, SEARCH_DEBOUNCE_VALUE_MS, [cachedListParams]);
  const deleteButton = selectedItems.length ? /*#__PURE__*/_react.default.createElement(_components.SnapshotDeleteProvider, null, deleteSnapshotPrompt => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => deleteSnapshotPrompt(selectedItems.map(({
        snapshot,
        repository
      }) => ({
        snapshot,
        repository
      })), onSnapshotDeleted),
      color: "danger",
      "data-test-subj": "srSnapshotListBulkDeleteActionButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotList.table.deleteSnapshotButton",
      defaultMessage: "Delete {count, plural, one {snapshot} other {snapshots}}",
      values: {
        count: selectedItems.length
      }
    }));
  }) : [];
  const searchFilters = [{
    type: 'field_value_selection',
    field: 'repository',
    name: _i18n.i18n.translate('xpack.snapshotRestore.snapshotList.table.repositoryFilterLabel', {
      defaultMessage: 'Repository'
    }),
    operator: 'exact',
    multiSelect: false,
    options: repositories.map(repository => ({
      value: repository,
      view: repository
    }))
  }];
  const reloadButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    iconType: "refresh",
    onClick: reload,
    "data-test-subj": "reloadButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotList.table.reloadSnapshotsButton",
    defaultMessage: "Reload"
  }));
  const [query, setQuery] = (0, _react.useState)((0, _lib.getQueryFromListParams)(listParams, searchSchema));
  const [error, setError] = (0, _react.useState)(null);
  const onSearchBarChange = args => {
    const {
      query: changedQuery,
      error: queryError
    } = args;
    if (queryError) {
      setError(queryError);
    } else if (changedQuery) {
      setError(null);
      setQuery(changedQuery);
      if (changedQuery.ast.clauses.length > 1) {
        setError({
          name: onlyOneClauseMessage,
          message: onlyOneClauseMessage
        });
      } else {
        setCachedListParams((0, _lib.getListParams)(listParams, changedQuery));
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    filters: searchFilters,
    query: query,
    onChange: onSearchBarChange,
    toolsLeft: deleteButton,
    toolsRight: reloadButton,
    box: {
      schema: searchSchema,
      incremental: true,
      'data-test-subj': 'snapshotListSearch'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "snapshotListSearchError",
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotList.searchBar.invalidSearchMessage",
      defaultMessage: "Invalid search: {errorMessage}",
      values: {
        errorMessage: error.message
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null);
};
exports.SnapshotSearchBar = SnapshotSearchBar;