"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../../shared_imports");
var _common = require("../../../../../common");
var _constants = require("../../../constants");
var _lib = require("../../../lib");
var _http = require("../../../services/http");
var _navigation = require("../../../services/navigation");
var _app_context = require("../../../app_context");
var _policy_details = require("./policy_details");
var _policy_table = require("./policy_table");
var _policy_retention_schedule = require("./policy_retention_schedule");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyList = ({
  history
}) => {
  const {
    policyName
  } = (0, _lib.useDecodedParams)();
  const {
    error,
    isLoading,
    data: {
      policies
    } = {
      policies: undefined
    },
    resendRequest: reload
  } = (0, _http.useLoadPolicies)();
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const {
    core
  } = (0, _app_context.useAppContext)();

  // Load retention cluster settings
  const {
    isLoading: isLoadingRetentionSettings,
    error: retentionSettingsError,
    data: retentionSettings,
    resendRequest: reloadRetentionSettings
  } = (0, _http.useLoadRetentionSettings)();
  const openPolicyDetailsUrl = newPolicyName => {
    return (0, _navigation.linkToPolicy)(newPolicyName);
  };
  const closePolicyDetails = () => {
    history.push(`${_constants.BASE_PATH}/policies`);
  };
  const onPolicyDeleted = policiesDeleted => {
    if (policyName && policiesDeleted.includes(policyName)) {
      closePolicyDetails();
    }
    if (policiesDeleted.length) {
      reload();
    }
  };
  const onPolicyExecuted = () => {
    reload();
  };

  // Track component loaded
  (0, _react.useEffect)(() => {
    uiMetricService.trackUiMetric(_constants.UIM_POLICY_LIST_LOAD);
  }, [uiMetricService]);
  (0, _shared_imports.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'snapshotRestorePolicyTab'
  });
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.loadingPoliciesDescription",
      defaultMessage: "Loading policies\u2026"
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyList.LoadingPoliciesErrorMessage",
        defaultMessage: "Error loading policies"
      }),
      error: error
    });
  } else if (policies && policies.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      hasShadow: false,
      paddingSize: "none",
      verticalPosition: "center",
      horizontalPosition: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyList.emptyPromptTitle",
        defaultMessage: "Create your first snapshot policy"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyList.emptyPromptDescription",
        defaultMessage: "A policy automates the creation and deletion of snapshots."
      }))),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToAddPolicy)()), {
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "createPolicyButton"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.createPolicyButton",
        defaultMessage: "Create a policy"
      })),
      "data-test-subj": "emptyPrompt"
    }));
  } else {
    const policySchedules = policies.map(policy => policy.schedule);
    const hasDuplicateSchedules = policySchedules.length > new Set(policySchedules).size;
    const hasRetention = Boolean(policies.find(policy => policy.retention));
    content = /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "policyList"
    }, hasDuplicateSchedules ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyScheduleWarningTitle",
        defaultMessage: "Two or more policies have the same schedule"
      }),
      color: "warning",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyScheduleWarningDescription",
      defaultMessage: "Only one snapshot can be taken at a time. To avoid snapshot failures, edit or delete the policies."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, hasRetention ? /*#__PURE__*/_react.default.createElement(_policy_retention_schedule.PolicyRetentionSchedule, {
      retentionSettings: retentionSettings,
      onRetentionScheduleUpdated: reloadRetentionSettings,
      isLoading: isLoadingRetentionSettings,
      error: retentionSettingsError
    }) : null, /*#__PURE__*/_react.default.createElement(_policy_table.PolicyTable, {
      policies: policies || [],
      reload: reload,
      openPolicyDetailsUrl: openPolicyDetailsUrl,
      onPolicyDeleted: onPolicyDeleted,
      onPolicyExecuted: onPolicyExecuted
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: _common.APP_SLM_CLUSTER_PRIVILEGES.map(name => `cluster.${name}`)
  }, ({
    hasPrivileges,
    privilegesMissing
  }) => hasPrivileges ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, policyName ? /*#__PURE__*/_react.default.createElement(_policy_details.PolicyDetails, {
    policyName: policyName,
    onClose: closePolicyDetails,
    onPolicyDeleted: onPolicyDeleted,
    onPolicyExecuted: onPolicyExecuted
  }) : null, content) : /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.deniedPrivilegeTitle",
      defaultMessage: "You're missing cluster privileges"
    }),
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.deniedPrivilegeDescription",
      defaultMessage: "To manage Snapshot Lifecycle Policies, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",
      values: {
        missingPrivileges: privilegesMissing.cluster.join(', '),
        privilegesCount: privilegesMissing.cluster.length
      }
    })
  }));
};
exports.PolicyList = PolicyList;