"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var _i18n = require("@kbn/i18n");
var _http = require("./services/http");
var _navigation = require("./services/navigation");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function mountManagementSection(coreSetup, services, config, params) {
  const {
    element,
    setBreadcrumbs,
    history,
    theme$
  } = params;
  const [core] = await coreSetup.getStartServices();
  const {
    chrome: {
      docTitle
    }
  } = core;
  _navigation.docTitleService.setup(docTitle.change);
  _navigation.breadcrumbService.setup(setBreadcrumbs);
  const appDependencies = {
    core,
    config,
    services: {
      uiSettings: coreSetup.uiSettings,
      httpService: _http.httpService,
      uiMetricService: services.uiMetricService,
      i18n: _i18n.i18n,
      history
    },
    theme$
  };
  const unmountAppCallback = (0, _.renderApp)(element, appDependencies);
  return () => {
    docTitle.reset();
    unmountAppCallback();
  };
}