"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionExecuteModalProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../app_context");
var _http = require("../services/http");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RetentionExecuteModalProvider = ({
  children
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const toastNotifications = (0, _app_context.useToastNotifications)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const executeRetentionPrompt = () => {
    setIsModalOpen(true);
  };
  const closeModal = () => {
    setIsModalOpen(false);
  };
  const executeRetention = () => {
    (0, _http.executeRetention)().then(({
      error
    }) => {
      if (error) {
        const errorMessage = i18n.translate('xpack.snapshotRestore.executeRetention.errorMessage', {
          defaultMessage: 'Error running retention'
        });
        toastNotifications.addDanger(errorMessage);
      } else {
        const successMessage = i18n.translate('xpack.snapshotRestore.executeRetention.successMessage', {
          defaultMessage: 'Retention is running'
        });
        toastNotifications.addSuccess(successMessage);
      }
    });
    closeModal();
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executeRetention.confirmModal.executeRetentionTitle",
        defaultMessage: "Run snapshot retention now?"
      }),
      onCancel: closeModal,
      onConfirm: executeRetention,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executeRetention.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executeRetention.confirmModal.confirmButtonLabel",
        defaultMessage: "Run retention"
      }),
      "data-test-subj": "executeRetentionModal"
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children(executeRetentionPrompt), renderModal());
};
exports.RetentionExecuteModalProvider = RetentionExecuteModalProvider;