"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshotStepSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../constants");
var _app_context = require("../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RestoreSnapshotStepSettings = ({
  restoreSettings,
  updateRestoreSettings,
  snapshotDetails,
  errors
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const {
    indexSettings,
    ignoreIndexSettings
  } = restoreSettings;
  const {
    dataStreams
  } = snapshotDetails;

  // State for index setting toggles
  const [isUsingIndexSettings, setIsUsingIndexSettings] = (0, _react.useState)(Boolean(indexSettings));
  const [isUsingIgnoreIndexSettings, setIsUsingIgnoreIndexSettings] = (0, _react.useState)(Boolean(ignoreIndexSettings));

  // Caching state for togglable settings
  const [cachedRestoreSettings, setCachedRestoreSettings] = (0, _react.useState)({
    indexSettings: indexSettings || '{}',
    ignoreIndexSettings: ignoreIndexSettings ? [...ignoreIndexSettings] : []
  });

  // List of settings for ignore settings combobox suggestions, using a state because users can add custom settings
  const [ignoreIndexSettingsOptions, setIgnoreIndexSettingsOptions] = (0, _react.useState)([...new Set((ignoreIndexSettings || []).concat([..._constants.REMOVE_INDEX_SETTINGS_SUGGESTIONS].sort()))].map(setting => ({
    label: setting
  })));

  // Index settings doc link
  const indexSettingsDocLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.elasticsearch.indexModules,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsDocLinkText",
    defaultMessage: "Learn more."
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "snapshotRestore__restoreForm__stepSettings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepSettingsTitle",
    defaultMessage: "Index settings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: docLinks.links.snapshotRestore.changeIndexSettings,
    target: "_blank",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepSettings.docsButtonLabel",
    defaultMessage: "Index settings docs"
  })))), dataStreams !== null && dataStreams !== void 0 && dataStreams.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "help",
    title: i18n.translate('xpack.snapshotRestore.restoreForm.stepSettings.dataStreamsCallout.title', {
      defaultMessage: 'Backing indices'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepSettings.dataStreamsCallout.description",
    defaultMessage: "These settings also apply to the backing indices of data streams."
  }))) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsTitle",
      defaultMessage: "Modify index settings"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsDescription",
      defaultMessage: "Overrides index settings during restore. {docLink}",
      values: {
        docLink: indexSettingsDocLink
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "modifyIndexSettingsSwitch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsLabel",
      defaultMessage: "Modify index settings"
    }),
    checked: isUsingIndexSettings,
    onChange: e => {
      const isChecked = e.target.checked;
      if (isChecked) {
        setIsUsingIndexSettings(true);
        updateRestoreSettings({
          indexSettings: cachedRestoreSettings.indexSettings
        });
      } else {
        setIsUsingIndexSettings(false);
        updateRestoreSettings({
          indexSettings: undefined
        });
      }
    }
  }), !isUsingIndexSettings ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsEditorLabel",
      defaultMessage: "Index settings"
    }),
    fullWidth: true,
    isInvalid: Boolean(errors.indexSettings),
    error: errors.indexSettings,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsEditorDescription",
      defaultMessage: "Use JSON format: {format}",
      values: {
        format: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '{ "index.number_of_replicas": 0 }')
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    languageId: "json",
    value: indexSettings,
    height: 250,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    "aria-label": i18n.translate('xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsAriaLabel', {
      defaultMessage: 'Index settings to modify'
    }),
    onChange: value => {
      updateRestoreSettings({
        indexSettings: value
      });
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        indexSettings: value
      });
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsTitle",
      defaultMessage: "Reset index settings"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsDescription",
      defaultMessage: "Resets selected settings to default during restore. {docLink}",
      values: {
        docLink: indexSettingsDocLink
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsLabel",
      defaultMessage: "Reset index settings"
    }),
    checked: isUsingIgnoreIndexSettings,
    onChange: e => {
      const isChecked = e.target.checked;
      if (isChecked) {
        setIsUsingIgnoreIndexSettings(true);
        updateRestoreSettings({
          ignoreIndexSettings: [...(cachedRestoreSettings.ignoreIndexSettings || [])]
        });
      } else {
        setIsUsingIgnoreIndexSettings(false);
        updateRestoreSettings({
          ignoreIndexSettings: undefined
        });
      }
    }
  }), !isUsingIgnoreIndexSettings ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepSettings.selectIgnoreIndexSettingsLabel",
      defaultMessage: "Select settings"
    }),
    isInvalid: Boolean(errors.ignoreIndexSettings),
    error: errors.ignoreIndexSettings
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: i18n.translate('xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsPlaceholder', {
      defaultMessage: 'Select or type index settings'
    }),
    options: ignoreIndexSettingsOptions,
    selectedOptions: ignoreIndexSettings ? ignoreIndexSettingsOptions.filter(({
      label
    }) => ignoreIndexSettings.includes(label)) : [],
    onChange: selectedOptions => {
      const newIgnoreIndexSettings = selectedOptions.map(({
        label
      }) => label);
      updateRestoreSettings({
        ignoreIndexSettings: newIgnoreIndexSettings
      });
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        ignoreIndexSettings: newIgnoreIndexSettings
      });
    },
    onCreateOption: (newIndexSetting, flattenedOptions) => {
      const normalizedSettingName = newIndexSetting.trim().toLowerCase();
      if (!normalizedSettingName) {
        return;
      }
      const isCustomSetting = !Boolean(flattenedOptions.find(({
        label
      }) => label === normalizedSettingName));
      if (isCustomSetting) {
        setIgnoreIndexSettingsOptions([{
          label: normalizedSettingName
        }, ...ignoreIndexSettingsOptions]);
      }
      updateRestoreSettings({
        ignoreIndexSettings: [...(ignoreIndexSettings || []), normalizedSettingName]
      });
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        ignoreIndexSettings: [...(ignoreIndexSettings || []), normalizedSettingName]
      });
    },
    isClearable: true
  })))))));
};
exports.RestoreSnapshotStepSettings = RestoreSnapshotStepSettings;