"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChunkSizeField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChunkSizeField = ({
  isInvalid,
  error,
  defaultValue,
  updateSettings
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.commonFields.chunkSizeTitle",
      defaultMessage: "Chunk size"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.commonFields.chunkSizeDescription",
      defaultMessage: "Breaks files into smaller units when taking snapshots."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.commonFields.chunkSizeLabel",
      defaultMessage: "Chunk size"
    }),
    fullWidth: true,
    isInvalid: isInvalid,
    error: error,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.commonFields.chunkSizeHelpText",
      defaultMessage: "Accepts byte size units, such as {example1}, {example2}, {example3}, or {example4}. Defaults to unlimited.",
      values: {
        example1: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "1g"),
        example2: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "10mb"),
        example3: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "5k"),
        example4: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "1024B")
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: defaultValue,
    fullWidth: true,
    onChange: e => updateSettings('chunkSize', e.target.value),
    "data-test-subj": "chunkSizeInput"
  })));
};
exports.ChunkSizeField = ChunkSizeField;