"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../../../common/lib");
var _validation = require("../../services/validation");
var _step_one = require("./step_one");
var _step_two = require("./step_two");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryForm = ({
  repository: originalRepository,
  isManagedRepository,
  isEditing,
  isSaving,
  saveError,
  clearSaveError,
  onSave
}) => {
  const [currentStep, setCurrentStep] = (0, _react.useState)(isEditing ? 2 : 1);

  // Repository state
  const [repository, setRepository] = (0, _react.useState)({
    ...originalRepository,
    settings: {
      ...originalRepository.settings
    }
  });

  // Repository validation state
  const [validation, setValidation] = (0, _react.useState)({
    isValid: true,
    errors: {}
  });
  const updateRepository = updatedFields => {
    const newRepository = {
      ...repository,
      ...updatedFields
    };
    setRepository(newRepository);
  };
  const saveRepository = () => {
    const newValidation = (0, _validation.validateRepository)(repository, true);
    const {
      isValid
    } = newValidation;
    setValidation(newValidation);
    if (isValid) {
      onSave(repository);
    }
  };
  const goToNextStep = () => {
    const newValidation = (0, _validation.validateRepository)(repository, false);
    const {
      isValid
    } = newValidation;
    setValidation(newValidation);
    if (isValid) {
      setCurrentStep(2);
    }
  };
  const goToPreviousStep = () => {
    if (isEditing) {
      return;
    }
    setValidation({
      isValid: true,
      errors: {}
    });
    setCurrentStep(1);
    clearSaveError();
  };
  const hasValidationErrors = !validation.isValid;
  const validationErrors = Object.entries((0, _lib.flatten)(validation.errors)).reduce((acc, [key, value]) => {
    return [...acc, value];
  }, []);
  const renderStepOne = () => /*#__PURE__*/_react.default.createElement(_step_one.RepositoryFormStepOne, {
    repository: repository,
    onNext: () => goToNextStep(),
    updateRepository: updateRepository,
    validation: validation
  });
  const renderStepTwo = () => /*#__PURE__*/_react.default.createElement(_step_two.RepositoryFormStepTwo, {
    repository: repository,
    isManagedRepository: isManagedRepository,
    isEditing: isEditing,
    isSaving: isSaving,
    onSave: saveRepository,
    updateRepository: updateRepository,
    validation: validation,
    saveError: saveError,
    onBack: () => goToPreviousStep()
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: hasValidationErrors,
    error: validationErrors,
    "data-test-subj": "repositoryForm"
  }, currentStep === 1 && !isEditing ? renderStepOne() : renderStepTwo());
};
exports.RepositoryForm = RepositoryForm;
RepositoryForm.defaultProps = {
  isEditing: false,
  isSaving: false
};