"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryDeleteProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../app_context");
var _http = require("../services/http");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryDeleteProvider = ({
  children
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const toastNotifications = (0, _app_context.useToastNotifications)();
  const [repositoryNames, setRepositoryNames] = (0, _react.useState)([]);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const deleteRepositoryPrompt = (names, onSuccess = () => undefined) => {
    if (!names || !names.length) {
      throw new Error('No repository names specified for deletion');
    }
    setIsModalOpen(true);
    setRepositoryNames(names);
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setIsModalOpen(false);
    setRepositoryNames([]);
  };
  const deleteRepository = () => {
    const repositoriesToDelete = [...repositoryNames];
    (0, _http.deleteRepositories)(repositoriesToDelete).then(({
      data,
      error
    }) => {
      const {
        itemsDeleted,
        errors
      } = data || {
        itemsDeleted: undefined,
        errors: undefined
      };

      // Surface success notifications
      if (itemsDeleted && itemsDeleted.length) {
        const hasMultipleSuccesses = itemsDeleted.length > 1;
        const successMessage = hasMultipleSuccesses ? i18n.translate('xpack.snapshotRestore.deleteRepository.successMultipleNotificationTitle', {
          defaultMessage: 'Removed {count} repositories',
          values: {
            count: itemsDeleted.length
          }
        }) : i18n.translate('xpack.snapshotRestore.deleteRepository.successSingleNotificationTitle', {
          defaultMessage: "Removed repository '{name}'",
          values: {
            name: itemsDeleted[0]
          }
        });
        toastNotifications.addSuccess(successMessage);
        if (onSuccessCallback.current) {
          onSuccessCallback.current([...itemsDeleted]);
        }
      }

      // Surface error notifications
      // `error` is generic server error
      // `data.errors` are specific errors with removing particular repository(ies)
      if (error || errors && errors.length) {
        const hasMultipleErrors = errors && errors.length > 1 || error && repositoriesToDelete.length > 1;
        const errorMessage = hasMultipleErrors ? i18n.translate('xpack.snapshotRestore.deleteRepository.errorMultipleNotificationTitle', {
          defaultMessage: 'Error removing {count} repositories',
          values: {
            count: errors && errors.length || repositoriesToDelete.length
          }
        }) : i18n.translate('xpack.snapshotRestore.deleteRepository.errorSingleNotificationTitle', {
          defaultMessage: "Error removing repository '{name}'",
          values: {
            name: errors && errors[0].name || repositoriesToDelete[0]
          }
        });
        toastNotifications.addDanger(errorMessage);
      }
    });
    closeModal();
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    const isSingle = repositoryNames.length === 1;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: isSingle ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteRepository.confirmModal.deleteSingleTitle",
        defaultMessage: "Remove repository '{name}'?",
        values: {
          name: repositoryNames[0]
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteRepository.confirmModal.deleteMultipleTitle",
        defaultMessage: "Remove {count} repositories?",
        values: {
          count: repositoryNames.length
        }
      }),
      onCancel: closeModal,
      onConfirm: deleteRepository,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteRepository.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: isSingle ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteRepository.confirmModal.confirmSingleButtonLabel",
        defaultMessage: "Remove repository"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteRepository.confirmModal.confirmMultipleButtonLabel",
        defaultMessage: "Remove repositories"
      }),
      buttonColor: "danger",
      "data-test-subj": "deleteRepositoryConfirmation"
    }, isSingle ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.deleteRepository.confirmModal.deleteSingleDescription",
      defaultMessage: "The snapshots in this repository will still exist, but Elasticsearch won\u2019t have access to them. Adjust policies that use this repository to prevent scheduled snapshots from failing."
    })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.deleteRepository.confirmModal.deleteMultipleListDescription",
      defaultMessage: "You are about to remove these repositories:"
    })), /*#__PURE__*/_react.default.createElement("ul", null, repositoryNames.map(name => /*#__PURE__*/_react.default.createElement("li", {
      key: name
    }, name))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.deleteRepository.confirmModal.deleteMultipleDescription",
      defaultMessage: "The snapshots in these repositories will still exist, but Elasticsearch won't have access to them. Adjust policies that use these repositories to prevent scheduled snapshots from failing."
    }))));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(deleteRepositoryPrompt), renderModal());
};
exports.RepositoryDeleteProvider = RepositoryDeleteProvider;