"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSelectionToIndicesOptions = exports.determineListMode = void 0;
var _react = _interopRequireDefault(require("react"));
var _lib = require("../../../../../lib");
var _data_stream_badge = require("../../../../../data_stream_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapSelectionToIndicesOptions = ({
  allSelected,
  selection,
  dataStreams,
  indices
}) => {
  return (0, _lib.orderDataStreamsAndIndices)({
    dataStreams: dataStreams.map(dataStream => {
      return {
        label: dataStream,
        append: /*#__PURE__*/_react.default.createElement(_data_stream_badge.DataStreamBadge, null),
        checked: allSelected || selection.includes(dataStream) ? 'on' : undefined
      };
    }),
    indices: indices.map(index => {
      return {
        label: index,
        checked: allSelected || selection.includes(index) ? 'on' : undefined
      };
    })
  });
};

/**
 * @remark
 * Users with more than 100 indices will probably want to use an index pattern to select
 * them instead, so we'll default to showing them the index pattern input. Also show the custom
 * list if we have no exact matches in the configured array to some existing index.
 */
exports.mapSelectionToIndicesOptions = mapSelectionToIndicesOptions;
const determineListMode = ({
  configuredIndices,
  indices,
  dataStreams
}) => {
  const indicesAndDataStreams = indices.concat(dataStreams);
  return typeof configuredIndices === 'string' || indicesAndDataStreams.length > 100 || Array.isArray(configuredIndices) &&
  // If not every past configured index maps to an existing index or data stream
  // we also show the custom list
  !configuredIndices.every(c => indicesAndDataStreams.some(i => i === c)) ? 'custom' : 'list';
};
exports.determineListMode = determineListMode;