"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _validation = require("../../services/validation");
var _steps = require("./steps");
var _navigation = require("./navigation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyForm = ({
  policy: originalPolicy,
  dataStreams,
  indices,
  currentUrl,
  isEditing,
  isSaving,
  saveError,
  clearSaveError,
  onCancel,
  onSave
}) => {
  var _originalPolicy$reten, _originalPolicy$reten2;
  // Step state
  const [currentStep, setCurrentStep] = (0, _react.useState)(1);
  const [maxCompletedStep, setMaxCompletedStep] = (0, _react.useState)(0);
  const stepMap = {
    1: _steps.PolicyStepLogistics,
    2: _steps.PolicyStepSettings,
    3: _steps.PolicyStepRetention,
    4: _steps.PolicyStepReview
  };
  const CurrentStepForm = stepMap[currentStep];

  // Policy state
  const [policy, setPolicy] = (0, _react.useState)({
    ...originalPolicy,
    config: {
      // When creating a new policy includesGlobalState is enabled by default and the API will also
      // include all featureStates into the snapshot when this happens. We need to take this case into account
      // when creating the local state for the form and also set featureStates to be an empty array, which
      // for the API it means that it will include all featureStates.
      featureStates: [],
      // IncludeGlobalState is set as default by the api, so we want to replicate that behaviour in our
      // form state so that it gets explicitly represented in the request.
      includeGlobalState: true,
      ...(originalPolicy.config || {})
    },
    retention: {
      ...originalPolicy.retention,
      expireAfterUnit: (_originalPolicy$reten = (_originalPolicy$reten2 = originalPolicy.retention) === null || _originalPolicy$reten2 === void 0 ? void 0 : _originalPolicy$reten2.expireAfterUnit) !== null && _originalPolicy$reten !== void 0 ? _originalPolicy$reten : _constants.TIME_UNITS.DAY
    }
  });
  const isEditingManagedPolicy = Boolean(isEditing && policy.isManagedPolicy);

  // Policy validation state
  const [validation, setValidation] = (0, _react.useState)({
    isValid: true,
    errors: {}
  });
  const updatePolicy = (updatedFields, validationHelperData = {}) => {
    const newPolicy = {
      ...policy,
      ...updatedFields
    };
    const newValidation = (0, _validation.validatePolicy)(newPolicy, validationHelperData);
    setPolicy(newPolicy);
    setValidation(newValidation);
  };
  const updateCurrentStep = step => {
    if (maxCompletedStep < step - 1) {
      return;
    }
    setCurrentStep(step);
    setMaxCompletedStep(step - 1);
    clearSaveError();
  };
  const onBack = () => {
    const previousStep = currentStep - 1;
    setCurrentStep(previousStep);
    setMaxCompletedStep(previousStep - 1);
    clearSaveError();
  };
  const onNext = () => {
    if (!validation.isValid) {
      return;
    }
    const nextStep = currentStep + 1;
    setMaxCompletedStep(Math.max(currentStep, maxCompletedStep));
    setCurrentStep(nextStep);
  };
  const savePolicy = () => {
    if (validation.isValid) {
      onSave(policy);
    }
  };
  const lastStep = Object.keys(stepMap).length;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_navigation.PolicyNavigation, {
    currentStep: currentStep,
    maxCompletedStep: maxCompletedStep,
    updateCurrentStep: updateCurrentStep,
    isFormValid: validation.isValid
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(CurrentStepForm, {
    policy: policy,
    indices: indices,
    dataStreams: dataStreams,
    updatePolicy: updatePolicy,
    isEditing: isEditing,
    currentUrl: currentUrl,
    errors: validation.errors,
    updateCurrentStep: updateCurrentStep
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), saveError ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, saveError, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, currentStep > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    onClick: () => onBack(),
    disabled: !validation.isValid
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.backButtonLabel",
    defaultMessage: "Back"
  }))) : null, currentStep < lastStep ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "arrowRight",
    onClick: () => onNext(),
    iconSide: "right",
    disabled: !validation.isValid,
    "data-test-subj": "nextButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.nextButtonLabel",
    defaultMessage: "Next"
  }))) : null, currentStep === lastStep ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: !isEditingManagedPolicy,
    color: isEditingManagedPolicy ? 'warning' : 'success',
    iconType: "check",
    onClick: () => savePolicy(),
    isLoading: isSaving,
    "data-test-subj": "submitButton"
  }, isSaving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.savingButtonLabel",
    defaultMessage: "Saving\u2026"
  }) : isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.saveButtonLabel",
    defaultMessage: "Save policy"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.createButtonLabel",
    defaultMessage: "Create policy"
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onCancel()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.PolicyForm = PolicyForm;